/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems;

import org.apache.commons.lang.WordUtils;

/**
 * @author Paolo Fabriani
 *
 */
public class CodedString implements Comparable<CodedString> {

    private String code;

    public CodedString(String code) {
        this.code = code;
    }

    public String getDisplayName() {
        switch (code) {
        case "iberian-biscay-irish-seas":
            return "Iberia-Biscay-Irish Regional Seas";
        case "north-west-shelf-seas":
            return "European North-West Shelf Seas";
        default:
            String out = code.trim();
            out = out.replaceAll("-", " ");
            out = out.replaceAll("_", " ");
            out = WordUtils.capitalize(out);
            String[] uncapitalize = {"of", "at", "in", "to", "as", "per", "by",
                    "from", "for", "and"};
            for (String unc : uncapitalize) {
                String find = " " + WordUtils.capitalize(unc) + " ";
                String repl = " " + unc + " ";
                out = out.replaceAll(find, repl);
            }
            return out;
        }
    }
    
    public int compareTo(CodedString other) {
        return this.code.compareTo(other.code);
    }
    
    public boolean equals(CodedString other) {
        return this.code.equals(other.code);
    }

}
