/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.model;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.dataanalysis.copernicus.motu.model.Axis;
import org.gcube.dataanalysis.copernicus.motu.model.TimeCoverage;
import org.gcube.dataanalysis.copernicus.motu.model.Variable;
import org.gcube.dataanalysis.copernicus.motu.util.TimeUtil;

@XmlRootElement(name="productMetadataInfo")
public class ProductMetadataInfo {
    private String code;
    private String msg;
    private String lastUpdate;
    private String url;
    private String title;
    private String id;
    private String rawAvailableTimeCodes;
    private String rawAvailableDepths;
    private TimeCoverage timeCoverage;
    private Collection<Variable> variables;
    private Collection<Axis> dataGeospatialCoverage;

    @XmlAttribute
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @XmlAttribute
    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @XmlAttribute
    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @XmlAttribute
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlAttribute
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement(name="availableTimes")
    public String getRawAvailableTimeCodes() {
        return this.rawAvailableTimeCodes;
    }

    public List<Calendar> getAvailableTimeCodes() {
        TreeSet<Calendar> out = new TreeSet<Calendar>();
        String codes = this.getRawAvailableTimeCodes();
        if (codes != null) {
            for (String timeCode : codes.split(";")) {
                try {
                    Calendar c = TimeUtil.toCalendar(timeCode);
                    out.add(c);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        return new Vector<Calendar>(out);
    }

    public Calendar getFirstAvailableTimeCode() {
        List<Calendar> timeCodes = this.getAvailableTimeCodes();
        if (timeCodes.size() > 0) {
            return timeCodes.get(0);
        }
        return null;
    }

    public Calendar getLastAvailableTimeCode() {
        List<Calendar> timeCodes = this.getAvailableTimeCodes();
        if (timeCodes.size() > 0) {
            return timeCodes.get(timeCodes.size() - 1);
        }
        return null;
    }

    public Long getTimeResolution() {
        double millisInHour = 3600000.0;
        Calendar from = this.getFirstAvailableTimeCode();
        Calendar to = this.getLastAvailableTimeCode();
        Integer howmany = this.getAvailableTimeCodes().size() - 1;
        Double elapsed = (double)(to.getTimeInMillis() - from.getTimeInMillis()) / 3600000.0;
        return Math.round(elapsed / (double)howmany.intValue());
    }

    public void setRawAvailableTimeCodes(String rawAvailableTimeCodes) {
        this.rawAvailableTimeCodes = rawAvailableTimeCodes;
    }

    @XmlElement(name="availableDepths")
    public String getRawAvailableDepths() {
        return this.rawAvailableDepths;
    }

    public List<Double> getAvailableDepths() {
        TreeSet<Double> out = new TreeSet<Double>();
        String depths = this.getRawAvailableDepths();
        if (depths != null) {
            for (String depth : depths.split(";")) {
                try {
                    Double d = Double.parseDouble(depth);
                    out.add(d);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return new Vector<Double>(out);
    }

    public Double getFirstAvailableDepth() {
        List<Double> depths = this.getAvailableDepths();
        if (depths.size() > 0) {
            return depths.get(0);
        }
        return null;
    }

    public Double getLastAvailableDepth() {
        List<Double> depths = this.getAvailableDepths();
        if (depths.size() > 0) {
            return depths.get(depths.size() - 1);
        }
        return null;
    }

    public void setRawAvailableDepths(String rawAvailableDepths) {
        this.rawAvailableDepths = rawAvailableDepths;
    }

    @XmlElement
    public TimeCoverage getTimeCoverage() {
        return this.timeCoverage;
    }

    public void setTimeCoverage(TimeCoverage timeCoverage) {
        this.timeCoverage = timeCoverage;
    }

    @XmlElement(name="variable")
    @XmlElementWrapper(name="variables")
    public Collection<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<Variable> variables) {
        this.variables = variables;
    }

    @XmlElement(name="axis")
    @XmlElementWrapper(name="dataGeospatialCoverage")
    public Collection<Axis> getDataGeospatialCoverage() {
        return this.dataGeospatialCoverage;
    }

    public void setDataGeospatialCoverage(Collection<Axis> dataGeospatialCoverage) {
        this.dataGeospatialCoverage = dataGeospatialCoverage;
    }
}

