/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import ucar.httpservices.HTTPUtil;

public class Escape {
    public static final Charset utf8Charset = Charset.forName("UTF-8");
    protected static final String _allowableInUrl = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$&'()*+,-./:;=?@_~";
    protected static final String _allowableInUrlQuery = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&'()*+,-./:;=?@_~";
    private static final char _URIEscape = '%';
    private static final char _BACKSLASHEscape = '\\';
    private static final String _MustBackslashEscape = "?#./\\\"'";
    static final byte blank = 32;
    static final byte plus = 43;
    static final byte hexa = 97;
    static final byte hexf = 102;
    static final byte hexA = 65;
    static final byte hexF = 70;
    static final byte hex0 = 48;
    static final byte hex9 = 57;
    static final byte ten = 10;
    private static final Pattern p = Pattern.compile("([\\w]+)://([.\\w]+(:[\\d]+)?)([/][^?#])?([?][^#]*)?([#].*)?");

    private static String xescapeString(String in, String allowable, char esc, boolean spaceplus) {
        try {
            StringBuffer out = new StringBuffer();
            if (in == null) {
                return null;
            }
            byte[] utf8 = in.getBytes(utf8Charset);
            byte[] allow8 = allowable.getBytes(utf8Charset);
            for (byte b : utf8) {
                if (b == 32 && spaceplus) {
                    out.append('+');
                    continue;
                }
                boolean found = false;
                for (byte a : allow8) {
                    if (a != b) continue;
                    found = true;
                    break;
                }
                if (found) {
                    out.append((char)b);
                    continue;
                }
                String c = Integer.toHexString(b);
                out.append(esc);
                if (c.length() < 2) {
                    out.append('0');
                }
                out.append(c);
            }
            return out.toString();
        }
        catch (Exception e) {
            return in;
        }
    }

    private static String escapeString(String in, String allowable) {
        return Escape.xescapeString(in, allowable, '%', false);
    }

    private static String xunescapeString(String in, char escape, boolean spaceplus) {
        try {
            if (in == null) {
                return null;
            }
            byte[] utf8 = in.getBytes(utf8Charset);
            byte escape8 = (byte)escape;
            byte[] out = new byte[utf8.length];
            int index8 = 0;
            int i = 0;
            while (i < utf8.length) {
                byte b;
                if ((b = utf8[i++]) == 43 && spaceplus) {
                    out[index8++] = 32;
                } else if (b == escape8 && i + 2 <= utf8.length) {
                    b = (byte)(Escape.fromHex(utf8[i]) << 4 | Escape.fromHex(utf8[i + 1]));
                    i += 2;
                }
                out[index8++] = b;
            }
            return new String(out, 0, index8, utf8Charset);
        }
        catch (Exception e) {
            return in;
        }
    }

    private static String unescapeString(String in) {
        return Escape.xunescapeString(in, '%', false);
    }

    private static byte fromHex(byte b) throws NumberFormatException {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(10 + (b - 97));
        }
        if (b >= 65 && b <= 70) {
            return (byte)(10 + (b - 65));
        }
        throw new NumberFormatException("Illegal hex character: " + b);
    }

    public static String escapeURL(String surl) {
        String protocol = null;
        String authority = null;
        String path = null;
        String query = null;
        String fragment = null;
        URI u = null;
        try {
            u = HTTPUtil.parseToURI(surl);
        }
        catch (URISyntaxException e) {
            return null;
        }
        protocol = u.getScheme();
        authority = u.getAuthority();
        path = u.getPath();
        query = u.getQuery();
        fragment = u.getFragment();
        StringBuilder url = new StringBuilder();
        url.append(protocol);
        url.append("://");
        url.append(authority);
        if (path != null && path.length() > 0) {
            String[] pieces = path.split("[/]", -1);
            for (int i = 0; i < pieces.length; ++i) {
                String p = pieces[i];
                if (p == null) {
                    p = "";
                }
                if (i > 0) {
                    url.append("/");
                }
                url.append(Escape.urlEncode(p));
            }
        }
        if (query != null && query.length() > 0) {
            url.append("?");
            url.append(Escape.escapeURLQuery(query));
        }
        if (fragment != null && fragment.length() > 0) {
            url.append("#");
            url.append(Escape.urlEncode(fragment));
        }
        return url.toString();
    }

    static int nextpiece(String s, int index, String sep) {
        if ((index = s.indexOf(sep, index)) < 0) {
            index = s.length();
        }
        return index;
    }

    public static String escapeURLQuery(String ce) {
        try {
            ce = Escape.escapeString(ce, _allowableInUrlQuery);
        }
        catch (Exception e) {
            ce = null;
        }
        return ce;
    }

    public static String unescapeURLQuery(String ce) {
        try {
            ce = Escape.unescapeString(ce);
        }
        catch (Exception e) {
            ce = null;
        }
        return ce;
    }

    public static String urlEncode(String s) {
        s = Escape.escapeString(s, _allowableInUrl);
        return s;
    }

    public static String urlDecode(String s) {
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public static String backslashDecode(String s) {
        StringBuilder buf = new StringBuilder(s);
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) != '\\') continue;
            buf.deleteCharAt(i);
        }
        return buf.toString();
    }

    public static String backslashEncode(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = buf.charAt(i);
            if (_MustBackslashEscape.indexOf(c) >= 0) {
                buf.append('\\');
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

