/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class BasicMultiPropertiesConfig
extends MultiPropertiesConfig {
    String[] rps;
    Map propsByResourcePaths = new HashMap();
    Map propsByPrefixes;
    Properties propsByKey;
    static /* synthetic */ Class class$com$mchange$v2$cfg$MultiPropertiesConfig;
    static /* synthetic */ Class class$com$mchange$v2$cfg$BasicMultiPropertiesConfig;

    public BasicMultiPropertiesConfig(String[] resourcePaths) {
        this(resourcePaths, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicMultiPropertiesConfig(String[] resourcePaths, MLogger logger) {
        ArrayList<String> goodPaths = new ArrayList<String>();
        int len = resourcePaths.length;
        for (int i = 0; i < len; ++i) {
            String rp = resourcePaths[i];
            if ("/".equals(rp)) {
                try {
                    this.propsByResourcePaths.put(rp, System.getProperties());
                    goodPaths.add(rp);
                }
                catch (SecurityException e) {
                    if (logger != null) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, "Read of system Properties blocked -- ignoring any configuration via System properties, and using Empty Properties! (But any configuration via a resource properties files is still okay!)", e);
                        continue;
                    }
                    System.err.println("Read of system Properties blocked -- ignoring any configuration via System properties, and using Empty Properties! (But any configuration via a resource properties files is still okay!)");
                    e.printStackTrace();
                }
                continue;
            }
            Properties p = new Properties();
            InputStream pis = (class$com$mchange$v2$cfg$MultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.MultiPropertiesConfig") : class$com$mchange$v2$cfg$MultiPropertiesConfig).getResourceAsStream(rp);
            if (pis != null) {
                try {
                    p.load(pis);
                    this.propsByResourcePaths.put(rp, p);
                    goodPaths.add(rp);
                    continue;
                }
                catch (IOException e) {
                    if (logger != null) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, "An IOException occurred while loading configuration properties from resource path '" + rp + "'.", e);
                        continue;
                    }
                    e.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        if (pis != null) {
                            pis.close();
                        }
                    }
                    catch (IOException e) {
                        if (logger != null) {
                            if (logger.isLoggable(MLevel.WARNING)) {
                                logger.log(MLevel.WARNING, "An IOException occurred while closing InputStream from resource path '" + rp + "'.", e);
                            }
                        }
                        e.printStackTrace();
                    }
                }
            }
            if (logger == null || !logger.isLoggable(MLevel.FINE)) continue;
            logger.fine("Configuration properties not found at ResourcePath '" + rp + "'. [logger name: " + logger.getName() + ']');
        }
        this.rps = goodPaths.toArray(new String[goodPaths.size()]);
        this.propsByPrefixes = Collections.unmodifiableMap(BasicMultiPropertiesConfig.extractPrefixMapFromRsrcPathMap(this.rps, this.propsByResourcePaths));
        this.propsByResourcePaths = Collections.unmodifiableMap(this.propsByResourcePaths);
        this.propsByKey = BasicMultiPropertiesConfig.extractPropsByKey(this.rps, this.propsByResourcePaths);
    }

    private static String extractPrefix(String s) {
        int lastdot = s.lastIndexOf(46);
        if (lastdot < 0) {
            return null;
        }
        return s.substring(0, lastdot);
    }

    private static Properties findProps(String rp, Map pbrp) {
        Properties p = (Properties)pbrp.get(rp);
        return p;
    }

    private static Properties extractPropsByKey(String[] resourcePaths, Map pbrp) {
        Properties out = new Properties();
        int len = resourcePaths.length;
        for (int i = 0; i < len; ++i) {
            String rp = resourcePaths[i];
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                System.err.println("Could not find loaded properties for resource path: " + rp);
                continue;
            }
            Iterator<Object> ii = p.keySet().iterator();
            while (ii.hasNext()) {
                Object kObj = ii.next();
                if (!(kObj instanceof String)) {
                    System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig") : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + ": " + "Properties object found at resource path " + ("/".equals(rp) ? "[system properties]" : "'" + rp + "'") + "' contains a key that is not a String: " + kObj);
                    System.err.println("Skipping...");
                    continue;
                }
                Object vObj = p.get(kObj);
                if (vObj != null && !(vObj instanceof String)) {
                    System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig") : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + ": " + "Properties object found at resource path " + ("/".equals(rp) ? "[system properties]" : "'" + rp + "'") + " contains a value that is not a String: " + vObj);
                    System.err.println("Skipping...");
                    continue;
                }
                String key = (String)kObj;
                String val2 = (String)vObj;
                out.put(key, val2);
            }
        }
        return out;
    }

    private static Map extractPrefixMapFromRsrcPathMap(String[] resourcePaths, Map pbrp) {
        HashMap<String, Properties> out = new HashMap<String, Properties>();
        int len = resourcePaths.length;
        for (int i = 0; i < len; ++i) {
            String rp = resourcePaths[i];
            Properties p = BasicMultiPropertiesConfig.findProps(rp, pbrp);
            if (p == null) {
                System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig") : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + " -- Could not find loaded properties for resource path: " + rp);
                continue;
            }
            Iterator<Object> jj = p.keySet().iterator();
            while (jj.hasNext()) {
                Object kObj = jj.next();
                if (!(kObj instanceof String)) {
                    System.err.println((class$com$mchange$v2$cfg$BasicMultiPropertiesConfig == null ? BasicMultiPropertiesConfig.class$("com.mchange.v2.cfg.BasicMultiPropertiesConfig") : class$com$mchange$v2$cfg$BasicMultiPropertiesConfig).getName() + ": " + "Properties object found at resource path " + ("/".equals(rp) ? "[system properties]" : "'" + rp + "'") + "' contains a key that is not a String: " + kObj);
                    System.err.println("Skipping...");
                    continue;
                }
                String key = (String)kObj;
                String prefix = BasicMultiPropertiesConfig.extractPrefix(key);
                while (prefix != null) {
                    Properties byPfx = (Properties)out.get(prefix);
                    if (byPfx == null) {
                        byPfx = new Properties();
                        out.put(prefix, byPfx);
                    }
                    byPfx.put(key, p.get(key));
                    prefix = BasicMultiPropertiesConfig.extractPrefix(prefix);
                }
            }
        }
        return out;
    }

    public String[] getPropertiesResourcePaths() {
        return (String[])this.rps.clone();
    }

    public Properties getPropertiesByResourcePath(String path) {
        Properties out = (Properties)this.propsByResourcePaths.get(path);
        return out == null ? new Properties() : out;
    }

    public Properties getPropertiesByPrefix(String pfx) {
        Properties out = (Properties)this.propsByPrefixes.get(pfx);
        return out == null ? new Properties() : out;
    }

    public String getProperty(String key) {
        return this.propsByKey.getProperty(key);
    }
}

