/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.CDMNode;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.util.Indent;
import ucar.unidata.util.Parameter;

@Immutable
public class Attribute
extends CDMNode {
    private String svalue;
    private DataType dataType;
    private int nelems;
    private Array values;
    private boolean isUnsigned;

    public static Map<String, Attribute> makeMap(List<Attribute> atts) {
        int size = atts == null ? 1 : atts.size();
        HashMap<String, Attribute> result = new HashMap<String, Attribute>(size);
        if (atts == null) {
            return result;
        }
        for (Attribute att : atts) {
            result.put(att.getShortName(), att);
        }
        return result;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isArray() {
        return this.getLength() > 1;
    }

    public int getLength() {
        return this.nelems;
    }

    public boolean isUnsigned() {
        return this.isUnsigned || this.values != null && this.values.isUnsigned();
    }

    public Array getValues() {
        if (this.values == null && this.svalue != null) {
            this.values = Array.factory(String.class, new int[]{1});
            this.values.setObject(this.values.getIndex(), (Object)this.svalue);
        }
        return this.values;
    }

    public Object getValue(int index) {
        if (this.isString()) {
            return this.getStringValue(index);
        }
        return this.getNumericValue(index);
    }

    public boolean isString() {
        return this.dataType == DataType.STRING && null != this.getStringValue();
    }

    public String getStringValue() {
        if (this.dataType != DataType.STRING) {
            return null;
        }
        return this.svalue != null ? this.svalue : this._getStringValue(0);
    }

    public String getStringValue(int index) {
        if (this.dataType != DataType.STRING) {
            return null;
        }
        if (this.svalue != null && index == 0) {
            return this.svalue;
        }
        return this._getStringValue(index);
    }

    private String _getStringValue(int index) {
        if (index < 0 || index >= this.nelems) {
            return null;
        }
        return (String)this.values.getObject(index);
    }

    public Number getNumericValue() {
        return this.getNumericValue(0);
    }

    public Number getNumericValue(int index) {
        if (index < 0 || index >= this.nelems) {
            return null;
        }
        if (this.dataType == DataType.STRING) {
            try {
                return new Double(this.getStringValue(index));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.dataType == DataType.BYTE) {
            return this.values.getByte(index);
        }
        if (this.dataType == DataType.SHORT) {
            return this.values.getShort(index);
        }
        if (this.dataType == DataType.INT) {
            return this.values.getInt(index);
        }
        if (this.dataType == DataType.FLOAT) {
            return Float.valueOf(this.values.getFloat(index));
        }
        if (this.dataType == DataType.DOUBLE) {
            return this.values.getDouble(index);
        }
        if (this.dataType == DataType.LONG) {
            return this.values.getLong(index);
        }
        return null;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean strict) {
        Formatter f = new Formatter();
        this.writeCDL(f, strict);
        return f.toString();
    }

    protected void writeCDL(Formatter f, boolean strict) {
        f.format("%s", strict ? NetcdfFile.makeValidCDLName(this.getShortName()) : this.getShortName());
        if (this.isString()) {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                String val2;
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                if ((val2 = this.getStringValue(i)) == null) continue;
                f.format("\"%s\"", NCdumpW.encodeString(val2));
            }
        } else {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                f.format("%s", this.getNumericValue(i));
                if (this.dataType == DataType.FLOAT) {
                    f.format("f", new Object[0]);
                    continue;
                }
                if (this.dataType == DataType.SHORT) {
                    if (this.isUnsigned()) {
                        f.format("US", new Object[0]);
                        continue;
                    }
                    f.format("S", new Object[0]);
                    continue;
                }
                if (this.dataType == DataType.BYTE) {
                    if (this.isUnsigned()) {
                        f.format("UB", new Object[0]);
                        continue;
                    }
                    f.format("B", new Object[0]);
                    continue;
                }
                if (this.dataType == DataType.LONG) {
                    if (this.isUnsigned()) {
                        f.format("UL", new Object[0]);
                        continue;
                    }
                    f.format("L", new Object[0]);
                    continue;
                }
                if (this.dataType != DataType.INT || !this.isUnsigned()) continue;
                f.format("U", new Object[0]);
            }
        }
    }

    public Attribute(String name, Attribute from) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("Trying to set name to null on " + this);
        }
        this.dataType = from.dataType;
        this.nelems = from.nelems;
        this.svalue = from.svalue;
        this.values = from.values;
        this.isUnsigned = from.isUnsigned;
        this.setImmutable(true);
    }

    public Attribute(String name, String val2) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("Trying to set name to null on " + this);
        }
        this.setStringValue(val2);
        this.setImmutable(true);
    }

    public Attribute(String name, Number val2) {
        this(name, val2, false);
    }

    public Attribute(String name, Number val2, boolean isUnsigned) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("Trying to set name to null on " + this);
        }
        int[] shape = new int[]{1};
        DataType dt = DataType.getType(val2.getClass());
        Array vala = Array.factory(dt.getPrimitiveClassType(), shape);
        Index ima = vala.getIndex();
        vala.setObject(ima.set0(0), (Object)val2);
        this.setValues(vala);
        this.isUnsigned = isUnsigned;
        if (isUnsigned) {
            vala.setUnsigned(true);
        }
        this.setImmutable(true);
    }

    public Attribute(String name, Array values) {
        this(name);
        this.setValues(values);
        this.setImmutable(true);
    }

    public Attribute(String name, DataType dataType, boolean isUnsigned) {
        this(name);
        this.dataType = dataType == DataType.CHAR ? DataType.STRING : dataType;
        this.nelems = 0;
        this.isUnsigned = isUnsigned;
        this.setImmutable(true);
    }

    public Attribute(String name, List values) {
        this(name);
        Object[] pa;
        int n = values.size();
        Class<?> c = values.get(0).getClass();
        if (c == String.class) {
            String[] va;
            pa = va = new String[n];
            for (int i = 0; i < n; ++i) {
                va[i] = (String)values.get(i);
            }
        } else if (c == Integer.class) {
            int[] va = new int[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Integer)values.get(i);
            }
        } else if (c == Double.class) {
            double[] va = new double[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Double)values.get(i);
            }
        } else if (c == Float.class) {
            float[] va = new float[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = ((Float)values.get(i)).floatValue();
            }
        } else if (c == Short.class) {
            short[] va = new short[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Short)values.get(i);
            }
        } else if (c == Byte.class) {
            byte[] va = new byte[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Byte)values.get(i);
            }
        } else if (c == Long.class) {
            long[] va = new long[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Long)values.get(i);
            }
        } else {
            throw new IllegalArgumentException("unknown type for Attribute = " + c.getName());
        }
        this.setValues(Array.factory(c, new int[]{n}, (Object)pa));
        this.setImmutable(true);
    }

    public Attribute(Parameter param) {
        this(param.getName());
        if (param.isString()) {
            this.setStringValue(param.getStringValue());
        } else {
            double[] values = param.getNumericValues();
            int n = values.length;
            Array vala = Array.factory(DataType.DOUBLE.getPrimitiveClassType(), new int[]{n}, (Object)values);
            this.setValues(vala);
        }
        this.setImmutable(true);
    }

    private void setStringValue(String val2) {
        int len;
        if (val2 == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        for (len = val2.length(); len > 0 && val2.charAt(len - 1) == '\u0000'; --len) {
        }
        if (len != val2.length()) {
            val2 = val2.substring(0, len);
        }
        this.svalue = val2;
        this.nelems = 1;
        this.dataType = DataType.STRING;
    }

    protected Attribute(String name) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("Trying to set name to null on " + this);
        }
    }

    protected void setValues(Array arr) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (arr == null) {
            this.dataType = DataType.STRING;
            return;
        }
        if (DataType.getType(arr.getElementType()) == null) {
            throw new IllegalArgumentException("Cant set Attribute with type " + arr.getElementType());
        }
        if (arr.getElementType() == Character.TYPE) {
            ArrayChar carr = (ArrayChar)arr;
            if (carr.getRank() == 1) {
                this.svalue = carr.getString();
                this.nelems = 1;
                this.dataType = DataType.STRING;
                return;
            }
            arr = carr.make1DStringArray();
        }
        if (arr.getElementType() == ByteBuffer.class) {
            int totalLen = 0;
            arr.resetLocalIterator();
            while (arr.hasNext()) {
                ByteBuffer bb = (ByteBuffer)arr.next();
                totalLen += bb.limit();
            }
            byte[] ba = new byte[totalLen];
            int pos = 0;
            arr.resetLocalIterator();
            while (arr.hasNext()) {
                ByteBuffer bb = (ByteBuffer)arr.next();
                System.arraycopy(bb.array(), 0, ba, pos, bb.limit());
                pos += bb.limit();
            }
            arr = Array.factory(DataType.BYTE, new int[]{totalLen}, (Object)ba);
        }
        if (arr.getRank() > 1) {
            arr = arr.reshape(new int[]{(int)arr.getSize()});
        }
        this.values = arr;
        this.nelems = (int)arr.getSize();
        this.dataType = DataType.getType(arr.getElementType());
    }

    public synchronized void setName(String name) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.setShortName(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Attribute)) {
            return false;
        }
        Attribute att = (Attribute)o;
        String name = this.getShortName();
        if (!name.equals(att.getShortName())) {
            return false;
        }
        if (this.nelems != att.nelems) {
            return false;
        }
        if (!this.dataType.equals((Object)att.dataType)) {
            return false;
        }
        if (this.isString()) {
            return att.getStringValue().equals(this.getStringValue());
        }
        if (this.values != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                int r2;
                int r1 = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                int n = r2 = att.isString() ? att.getStringValue(i).hashCode() : att.getNumericValue(i).hashCode();
                if (r1 == r2) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getShortName().hashCode();
        result = 37 * result + this.nelems;
        result = 37 * result + this.getDataType().hashCode();
        if (this.svalue != null) {
            result = 37 * result + this.svalue.hashCode();
        } else if (this.values != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                int h = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                result = 37 * result + h;
            }
        }
        return result;
    }

    @Override
    public void hashCodeShow(Indent indent) {
        System.out.printf("%sAtt hash = %d%n", indent, this.hashCode());
        System.out.printf("%s shortName '%s' = %d%n", indent, this.getShortName(), this.getShortName() == null ? -1 : this.getShortName().hashCode());
        System.out.printf("%s nelems %s%n", indent, this.nelems);
        System.out.printf("%s dataType %s%n", new Object[]{indent, this.getDataType()});
        if (this.svalue != null) {
            System.out.printf("%s svalue %s = %s%n", indent, this.svalue, this.svalue.hashCode());
        } else {
            indent.incr();
            for (int i = 0; i < this.getLength(); ++i) {
                if (this.isString()) {
                    System.out.printf("%s value %s = %s%n", indent, this.getStringValue(i), this.getStringValue(i).hashCode());
                    continue;
                }
                System.out.printf("%s value %s = %s%n", indent, this.getValue(i), this.getValue(i).hashCode());
            }
            indent.decr();
        }
    }
}

