/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.cover.impl;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MFile;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.constants.CDM;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.ft.cover.Coverage;
import ucar.nc2.ft.cover.CoverageCS;
import ucar.nc2.ft.cover.CoverageDataset;
import ucar.nc2.ft.cover.collection.CoverageProto;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

public class CoverageIndexWriter {
    public static final int version = 1;
    private static final Logger logger = LoggerFactory.getLogger(CoverageIndexWriter.class);
    public static final String MAGIC_START = "CoverageGridv01Index";

    /*
     * Loose catch block
     */
    public boolean writeIndex(String name, File idxFile, List<MFile> files, CoverageDataset cds) throws IOException {
        boolean deleteOnClose = false;
        if (idxFile.exists()) {
            RandomAccessFile.eject(idxFile.getPath());
            if (!idxFile.delete()) {
                logger.warn(" gc1 cant delete index file {}", (Object)idxFile.getPath());
            }
        }
        logger.debug(" createIndex for {}", (Object)idxFile.getPath());
        try {
            try (RandomAccessFile raf = new RandomAccessFile(idxFile.getPath(), "rw");){
                raf.order(0);
                raf.write(MAGIC_START.getBytes(CDM.utf8Charset));
                raf.writeInt(1);
                CoverageProto.GridCollection.Builder indexBuilder = CoverageProto.GridCollection.newBuilder();
                indexBuilder.setName(name);
                indexBuilder.setTopDir("faike");
                for (CoverageDataset.CoverageSet cset : cds.getCoverageSets()) {
                    indexBuilder.addCsets(this.writeCoverageSet(cset));
                }
                CoverageProto.GridCollection index = indexBuilder.build();
                byte[] b = index.toByteArray();
                NcStream.writeVInt(raf, b.length);
                raf.write(b);
                logger.debug("  write GribCollectionIndex= {} bytes", (Object)b.length);
                logger.debug("  file size =  %d bytes", (Object)raf.length());
                boolean bl = true;
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (deleteOnClose && !idxFile.delete()) {
                logger.error(" gc1 cant deleteOnClose index file {}", (Object)idxFile.getPath());
            }
        }
    }

    protected CoverageProto.CoverageSet writeCoverageSet(CoverageDataset.CoverageSet cset) throws IOException {
        CoverageProto.CoverageSet.Builder b = CoverageProto.CoverageSet.newBuilder();
        b.setName("fake");
        b.setCs(this.writeCoverageCS(cset.getCoverageCS()));
        for (Coverage coverage : cset.getCoverages()) {
            b.addCoverages(this.writeCoverage(coverage));
        }
        return b.build();
    }

    protected CoverageProto.CoverageCS writeCoverageCS(CoverageCS coverCS) throws IOException {
        CoverageProto.CoverageCS.Builder b = CoverageProto.CoverageCS.newBuilder();
        b.setName(coverCS.getName());
        for (CoordinateAxis axis : coverCS.getCoordinateAxes()) {
            b.addCoords(this.writeCoordinateAxis(axis));
        }
        for (CoordinateTransform transform : coverCS.getCoordinateTransforms()) {
            b.addTransforms(this.writeCoordinateTransform(transform));
        }
        return b.build();
    }

    protected CoverageProto.Coverage writeCoordinateAxis(CoordinateAxis axis) throws IOException {
        CoverageProto.Coverage.Builder b = CoverageProto.Coverage.newBuilder();
        b.setName(axis.getShortName());
        b.setDataType(axis.getDataType().ordinal());
        for (Attribute att : axis.getAttributes()) {
            b.addAtts(this.writeAttribute(att));
        }
        b.setAxisType(axis.getAxisType().ordinal());
        return b.build();
    }

    protected CoverageProto.CoordTransform writeCoordinateTransform(CoordinateTransform t) throws IOException {
        CoverageProto.CoordTransform.Builder b = CoverageProto.CoordTransform.newBuilder();
        b.setName(t.getName());
        b.setType(t.getTransformType() == TransformType.Projection ? CoverageProto.CoordTransform.Type.HORIZ : CoverageProto.CoordTransform.Type.VERT);
        for (Parameter att : t.getParameters()) {
            b.addAtts(this.writeParameter(att));
        }
        return b.build();
    }

    protected CoverageProto.Coverage writeCoverage(Coverage cover) throws IOException {
        CoverageProto.Coverage.Builder b = CoverageProto.Coverage.newBuilder();
        b.setName(cover.getShortName());
        b.setDataType(cover.getDataType().ordinal());
        for (Attribute att : cover.getAttributes()) {
            b.addAtts(this.writeAttribute(att));
        }
        return b.build();
    }

    protected CoverageProto.Attribute.Builder writeAttribute(Attribute att) throws IOException {
        CoverageProto.Attribute.Builder b = CoverageProto.Attribute.newBuilder();
        b.setName(att.getShortName());
        b.setDataType(att.getDataType().ordinal());
        b.setLen(att.getLength());
        if (att.isUnsigned()) {
            b.setUnsigned(true);
        }
        if (att.getLength() > 0) {
            if (att.isString()) {
                for (int i = 0; i < att.getLength(); ++i) {
                    b.addSdata(att.getStringValue(i));
                }
            } else {
                Array data = att.getValues();
                ByteBuffer bb = data.getDataAsByteBuffer();
                b.setData(ByteString.copyFrom(bb.array()));
            }
        }
        return b;
    }

    protected CoverageProto.Attribute.Builder writeParameter(Parameter att) throws IOException {
        CoverageProto.Attribute.Builder b = CoverageProto.Attribute.newBuilder();
        b.setName(att.getName());
        DataType dtype = att.isString() ? DataType.STRING : DataType.DOUBLE;
        b.setDataType(dtype.ordinal());
        b.setLen(att.getLength());
        if (att.isString()) {
            b.addSdata(att.getStringValue());
        } else {
            b.setData(ByteString.copyFrom(this.getDataAsByteArray(att)));
        }
        return b;
    }

    private byte[] getDataAsByteArray(Parameter p) {
        ByteBuffer bb = ByteBuffer.allocate(8 * p.getLength());
        DoubleBuffer ib = bb.asDoubleBuffer();
        for (double dval : p.getNumericValues()) {
            ib.put(dval);
        }
        return bb.array();
    }
}

