/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoder;
import com.mongodb.DBObject;
import com.mongodb.DBPortPool;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.OutMessage;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.util.ThreadUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBPort {
    public static final int PORT = 27017;
    static final boolean USE_NAGLE = false;
    static final long CONN_RETRY_TIME_MS = 15000L;
    final int _hashCode;
    final ServerAddress _sa;
    final InetSocketAddress _addr;
    final DBPortPool _pool;
    final MongoOptions _options;
    final Logger _logger;
    final DBDecoder _decoder;
    private Socket _socket;
    private InputStream _in;
    private OutputStream _out;
    private boolean _processingResponse;
    private Map<DB, Boolean> _authed = Collections.synchronizedMap(new WeakHashMap());
    int _lastThread;
    long _calls = 0L;
    private static Logger _rootLogger = Logger.getLogger("com.mongodb.port");

    public DBPort(ServerAddress addr) {
        this(addr, null, new MongoOptions());
    }

    DBPort(ServerAddress addr, DBPortPool pool, MongoOptions options) {
        this._options = options;
        this._sa = addr;
        this._addr = addr.getSocketAddress();
        this._pool = pool;
        this._hashCode = this._addr.hashCode();
        this._logger = Logger.getLogger(_rootLogger.getName() + "." + addr.toString());
        this._decoder = this._options.dbDecoderFactory.create();
    }

    Response call(OutMessage msg, DBCollection coll) throws IOException {
        return this.go(msg, coll);
    }

    void say(OutMessage msg) throws IOException {
        this.go(msg, null);
    }

    private synchronized Response go(OutMessage msg, DBCollection coll) throws IOException {
        return this.go(msg, coll, false);
    }

    private synchronized Response go(OutMessage msg, DBCollection coll, boolean forceReponse) throws IOException {
        if (this._processingResponse && coll != null) {
            throw new IllegalStateException("DBPort.go called and expecting a response while processing another response");
        }
        ++this._calls;
        if (this._socket == null) {
            this._open();
        }
        if (this._out == null) {
            throw new IllegalStateException("_out shouldn't be null");
        }
        try {
            msg.prepare();
            msg.pipe(this._out);
            if (this._pool != null) {
                this._pool._everWorked = true;
            }
            if (coll == null && !forceReponse) {
                Response response = null;
                return response;
            }
            this._processingResponse = true;
            DBDecoder decoder = this._decoder;
            if (coll.getDBDecoderFactory() != null) {
                decoder = coll.getDBDecoderFactory().create();
            }
            Response response = new Response(this._sa, coll, this._in, decoder);
            return response;
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
        finally {
            this._processingResponse = false;
        }
    }

    synchronized CommandResult getLastError(DB db, WriteConcern concern) throws IOException {
        DBApiLayer dbAL = (DBApiLayer)db;
        return this.runCommand(dbAL, (DBObject)concern.getCommand());
    }

    synchronized DBObject findOne(DB db, String coll, DBObject q) throws IOException {
        OutMessage msg = OutMessage.query(db._mongo, 0, db.getName() + "." + coll, 0, -1, q, null);
        Response res = this.go(msg, db.getCollection(coll));
        if (res.size() == 0) {
            return null;
        }
        if (res.size() > 1) {
            throw new MongoInternalException("something is wrong.  size:" + res.size());
        }
        return res.get(0);
    }

    synchronized CommandResult runCommand(DB db, DBObject cmd) throws IOException {
        DBObject res = this.findOne(db, "$cmd", cmd);
        if (res == null) {
            throw new MongoInternalException("something is wrong, no command result");
        }
        return (CommandResult)res;
    }

    synchronized DBObject findOne(String ns, DBObject q) throws IOException {
        OutMessage msg = OutMessage.query(null, 0, ns, 0, -1, q, null);
        Response res = this.go(msg, null, true);
        if (res.size() == 0) {
            return null;
        }
        if (res.size() > 1) {
            throw new MongoInternalException("something is wrong.  size:" + res.size());
        }
        return res.get(0);
    }

    synchronized CommandResult runCommand(String db, DBObject cmd) throws IOException {
        DBObject res = this.findOne(db + ".$cmd", cmd);
        if (res == null) {
            throw new MongoInternalException("something is wrong, no command result");
        }
        CommandResult cr = new CommandResult();
        cr.putAll(res);
        return cr;
    }

    synchronized CommandResult tryGetLastError(DB db, long last, WriteConcern concern) throws IOException {
        if (last != this._calls) {
            return null;
        }
        return this.getLastError(db, concern);
    }

    public synchronized void ensureOpen() throws IOException {
        if (this._socket != null) {
            return;
        }
        this._open();
    }

    boolean _open() throws IOException {
        long sleepTime = 100L;
        long maxAutoConnectRetryTime = 15000L;
        if (this._options.maxAutoConnectRetryTime > 0L) {
            maxAutoConnectRetryTime = this._options.maxAutoConnectRetryTime;
        }
        long start = System.currentTimeMillis();
        while (true) {
            IOException lastError = null;
            try {
                this._socket = this._options.socketFactory.createSocket();
                this._socket.connect(this._addr, this._options.connectTimeout);
                this._socket.setTcpNoDelay(true);
                this._socket.setKeepAlive(this._options.socketKeepAlive);
                this._socket.setSoTimeout(this._options.socketTimeout);
                this._in = new BufferedInputStream(this._socket.getInputStream());
                this._out = this._socket.getOutputStream();
                return true;
            }
            catch (IOException ioe) {
                lastError = new IOException("couldn't connect to [" + this._addr + "] bc:" + ioe);
                this._logger.log(Level.INFO, "connect fail to : " + this._addr, ioe);
                this.close();
                if (!this._options.autoConnectRetry || this._pool != null && !this._pool._everWorked) {
                    throw lastError;
                }
                long sleptSoFar = System.currentTimeMillis() - start;
                if (sleptSoFar >= maxAutoConnectRetryTime) {
                    throw lastError;
                }
                if (sleepTime + sleptSoFar > maxAutoConnectRetryTime) {
                    sleepTime = maxAutoConnectRetryTime - sleptSoFar;
                }
                this._logger.severe("going to sleep and retry.  total sleep time after = " + (sleptSoFar + sleptSoFar) + "ms  this time:" + sleepTime + "ms");
                ThreadUtil.sleep(sleepTime);
                sleepTime *= 2L;
                continue;
            }
            break;
        }
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String host() {
        return this._addr.toString();
    }

    public String toString() {
        return "{DBPort  " + this.host() + "}";
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    protected void close() {
        this._authed.clear();
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._in = null;
        this._out = null;
        this._socket = null;
    }

    void checkAuth(DB db) throws IOException {
        if (db._username == null) {
            if (db._name.equals("admin")) {
                return;
            }
            this.checkAuth(db._mongo.getDB("admin"));
            return;
        }
        if (this._authed.containsKey(db)) {
            return;
        }
        CommandResult res = this.runCommand(db, (DBObject)new BasicDBObject("getnonce", (Object)1));
        res.throwOnError();
        DBObject temp = db._authCommand(res.getString("nonce"));
        res = this.runCommand(db, temp);
        res.throwOnError();
        this._authed.put(db, true);
    }

    public DBPortPool getPool() {
        return this._pool;
    }
}

