/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ewe;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ewe.AbstractEwE;
import org.gcube.dataanalysis.ewe.util.FileSystemUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SimpleEwE
extends AbstractEwE {
    private static String MODEL_FILE = "Model File";
    private static String CONFIG_FILE = "Config File";
    private static Logger logger = Logger.getLogger((String)"SimpleEwE");
    private static final String MODEL_FILE_TAG_NAME = "model_file";

    @Override
    public void init() throws Exception {
        super.init();
        AnalysisLogger.getLogger().info((Object)"EwE Initialisation");
        AnalysisLogger.getLogger().info((Object)this.getDescription());
    }

    @Override
    public String getDescription() {
        return super.getDescription();
    }

    protected void setInputParameters() {
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, MODEL_FILE, "A file containing the model (e.g. Georgia_Strait.eiixml)"));
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, CONFIG_FILE, "A file containing execution parameters (e.g. run_config.xml)"));
    }

    @Override
    protected void prepareInput() throws Exception {
        FileSystemUtils fsu = new FileSystemUtils(this.getExecutionId());
        AnalysisLogger.getLogger().debug((Object)"Copying input files...");
        fsu.copyInputFileAs(this.config.getParam(CONFIG_FILE), CONFIG_FILE_NAME);
        String modelFileName = this.extractModelFileNameFromConfigFile(new File(fsu.getInputLocation(), CONFIG_FILE_NAME));
        fsu.copyInputFileAs(this.config.getParam(MODEL_FILE), modelFileName);
    }

    private String extractModelFileNameFromConfigFile(File config_file) throws Exception {
        DocumentBuilder builder;
        AnalysisLogger.getLogger().debug((Object)("Extracting model file name from " + config_file));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            AnalysisLogger.getLogger().error((Object)e);
            throw new Exception(e);
        }
        Document doc = null;
        try {
            doc = builder.parse(config_file);
        }
        catch (SAXException e) {
            AnalysisLogger.getLogger().error((Object)e);
            throw new Exception("Unable to parse the configuration file. Is it an xml file?");
        }
        catch (IOException e) {
            AnalysisLogger.getLogger().error((Object)e);
            throw new Exception("I/O problem in accessing the configuration file");
        }
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName(MODEL_FILE_TAG_NAME);
        String out = null;
        if (nList.getLength() == 0) {
            AnalysisLogger.getLogger().error((Object)"Can't find a tag named 'model_file' in the configuration file");
            throw new Exception("Unable to extract model name from the configuration file");
        }
        out = nList.item(0).getTextContent();
        if (nList.getLength() > 1) {
            AnalysisLogger.getLogger().warn((Object)("More than one model name found. Returning the first: " + out));
        }
        AnalysisLogger.getLogger().debug((Object)("Model file name is " + out));
        System.out.println(out);
        return out;
    }
}

