/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.TableAlreadyExistsException;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.preparedstatement.PreparedInsert;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.Selection;
import org.gcube.common.dbinterface.queries.update.CreateTable;
import org.gcube.common.dbinterface.queries.update.Delete;
import org.gcube.common.dbinterface.queries.update.Updater;
import org.gcube.common.dbinterface.queries.update.batch.BatchUpdater;
import org.gcube.common.dbinterface.registry.Connection;
import org.gcube.common.dbinterface.registry.DBInterface;
import org.gcube.common.dbinterface.registry.Shortcuts;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Attributes;
import org.gcube.common.dbinterface.utils.Conditions;
import org.gcube.common.dbinterface.utils.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemTableInfo {
    private static final Logger logger = LoggerFactory.getLogger(SystemTableInfo.class);
    private static final String SYSTEM_INFO_TABLE = "internalgcubesysteminfotable";
    private static final String TABLE_NAME_FIELD = "tablename";
    private static final String FIELD_NAME_FIELD = "fieldname";
    private static final String COLUMN_NAME_FIELD = "coulumnname";
    private DBInterface dbInterface;
    private static SystemTableInfo systemTableInfo = null;

    private SystemTableInfo(DBInterface dbInterface) throws Exception {
        this.dbInterface = dbInterface;
        Connection session = null;
        try {
            try {
                session = dbInterface.getConnection();
                this.create(session);
            }
            catch (TableAlreadyExistsException e) {
                logger.trace("the system table already exists");
                if (session != null) {
                    dbInterface.release(session);
                }
            }
        }
        finally {
            if (session != null) {
                dbInterface.release(session);
            }
        }
    }

    protected static SystemTableInfo getSystemInfo(DBInterface dbInterface) throws Exception {
        if (systemTableInfo == null) {
            systemTableInfo = new SystemTableInfo(dbInterface);
        }
        return systemTableInfo;
    }

    private void create(Connection session) throws TableAlreadyExistsException, Exception {
        Shortcuts sc = this.dbInterface.queries();
        CreateTable creator = (CreateTable)this.dbInterface.builders().createTable().name(SYSTEM_INFO_TABLE).columns(new ColumnDefinition[]{sc.column(TABLE_NAME_FIELD, Types.string((int)100), new Specification[]{Specification.NOT_NULL}), sc.column(FIELD_NAME_FIELD, Types.string((int)100), new Specification[]{Specification.NOT_NULL}), sc.column(COLUMN_NAME_FIELD, Types.string((int)100), new Specification[]{Specification.NOT_NULL})}).build();
        try {
            session.executeUpdate((Updater)creator);
        }
        catch (SQLException e) {
            throw new TableAlreadyExistsException(e.getMessage());
        }
    }

    protected TreeMap<String, String> retrieveInfo(String tableName) throws Exception {
        Select select = (Select)this.dbInterface.builders().select().values(new Attribute[]{Attributes.attribute((String)FIELD_NAME_FIELD), Attributes.attribute((String)COLUMN_NAME_FIELD)}).from(new Table[]{new Table(SYSTEM_INFO_TABLE)}).where((Condition)Conditions.eq((Object)Attributes.attribute((String)TABLE_NAME_FIELD), (String)tableName)).build();
        logger.trace("info query is {}", (Object)select.getQuery());
        TreeMap<String, String> toReturn = new TreeMap<String, String>();
        Connection session = this.dbInterface.getConnection();
        try {
            try {
                ResultSet res = session.executeQuery((Selection)select).asDefault();
                while (res.next()) {
                    toReturn.put(res.getString(FIELD_NAME_FIELD).toLowerCase(), res.getString(COLUMN_NAME_FIELD).toLowerCase());
                }
            }
            catch (SQLException e) {
                logger.error("error retrieving info", (Throwable)e);
                throw e;
            }
        }
        finally {
            this.dbInterface.release(session);
        }
        return toReturn;
    }

    protected String retrieveFieldName(String tableName, String columnName) throws Exception {
        Select select = (Select)this.dbInterface.builders().select().values(new Attribute[]{Attributes.attribute((String)FIELD_NAME_FIELD), Attributes.attribute((String)COLUMN_NAME_FIELD)}).from(new Table[]{new Table(SYSTEM_INFO_TABLE)}).where((Condition)Conditions.and((Condition[])new Condition[]{Conditions.eq((Object)Attributes.attribute((String)TABLE_NAME_FIELD), (String)tableName), Conditions.eq((Object)Attributes.attribute((String)COLUMN_NAME_FIELD), (String)columnName)})).build();
        Connection session = this.dbInterface.getConnection();
        try {
            ResultSet res = session.executeQuery((Selection)select).asDefault();
            if (!res.next()) {
                throw new Exception("error retrieving the field corresponding to column name " + columnName);
            }
            String string = res.getString(1);
            return string;
        }
        finally {
            this.dbInterface.release(session);
        }
    }

    protected void addInfo(Map<String, String> fieldMapping, final String tableName) throws Exception {
        Connection conn = this.dbInterface.getConnection();
        PreparedInsert preparedInsert = (PreparedInsert)this.dbInterface.builders().preparedInsert().table(SYSTEM_INFO_TABLE).elements(3).build();
        final Iterator<Map.Entry<String, String>> mappingIterator = fieldMapping.entrySet().iterator();
        Iterator<Object[]> it = new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return mappingIterator.hasNext();
            }

            @Override
            public Object[] next() {
                Map.Entry entry = (Map.Entry)mappingIterator.next();
                logger.trace("adding " + tableName + " - " + (String)entry.getKey() + "- " + (String)entry.getValue());
                return new Object[]{tableName, entry.getKey(), entry.getValue()};
            }

            @Override
            public void remove() {
                mappingIterator.remove();
            }
        };
        BatchUpdater updater = (BatchUpdater)this.dbInterface.builders().batchInsert().stopOnError().use(preparedInsert).elements((Iterator)it).build();
        logger.trace("prepared statement: {}", (Object)updater.getPreparedObject().getPreparedStatement());
        try {
            conn.executeBatchUpdate(updater);
        }
        finally {
            this.dbInterface.release(conn);
        }
    }

    protected void deleteInfo(String tableName) throws Exception {
        Delete deleteInfo = (Delete)this.dbInterface.builders().delete().table(SYSTEM_INFO_TABLE).where((Condition)Conditions.eq((Object)Attributes.attribute((String)TABLE_NAME_FIELD), (String)tableName)).build();
        Connection session = this.dbInterface.getConnection();
        try {
            session.executeUpdate((Updater)deleteInfo);
        }
        finally {
            if (session != null) {
                this.dbInterface.release(session);
            }
        }
    }
}

