/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dir.master.stubs.test;

import java.io.FileWriter;
import java.util.Properties;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;

public class RSGenerator {
    static GCUBEClientLog logger = new GCUBEClientLog(RSGenerator.class, new Properties[0]);

    public static void main(String[] args) {
        try {
            RSGenerator.run(args);
        }
        catch (Exception e) {
            logger.debug((Object)e.getClass().getSimpleName(), (Throwable)e);
        }
    }

    public static RSLocator run(String[] args) throws Exception {
        if (args.length < 6) {
            logger.debug((Object)"SPECIFY: 1) COLL ID 2) QUERY TERMS (comma-separated), 3) SIZE, 4) HOST:PORT, 5) SCOPE, 6) LOCATOR FILE");
            throw new IllegalArgumentException();
        }
        String collID = args[0];
        String[] queryTerms = args[1].split(",");
        int size = Integer.valueOf(args[2]);
        String host = args[3];
        GCUBEScope scope = GCUBEScope.getScope((String)args[4]);
        RSLocator locator = RSGenerator.generateResultSet(queryTerms, collID, size, host, scope);
        RSXMLIterator iter = RSXMLReader.getRSXMLReader((RSLocator)locator).makeLocal((RSResourceType)new RSResourceLocalType()).getRSIterator();
        while (iter.hasNext()) {
            logger.info((Object)(iter.next(ResultElementGeneric.class).RS_toXML() + "\n"));
        }
        FileWriter writer = new FileWriter(args[5]);
        writer.write(locator.getLocator());
        writer.close();
        logger.info((Object)("Serialised RS endpoint " + locator.getLocator()));
        return locator;
    }

    public static RSLocator generateResultSet(String[] queryTerms, String collectionID, int size, String host, GCUBEScope scope) throws Exception {
        logger.info((Object)"Generating resultset...");
        RSXMLWriter writer = RSXMLWriter.getRSXMLWriter();
        for (int i = 0; i < size; ++i) {
            writer.addResults(RSGenerator.generateResult(queryTerms, collectionID));
        }
        writer.close();
        return writer.getRSLocator((RSResourceType)new RSResourceWSRFType("http://" + host + "/wsrf/services/gcube/searchservice/ResultSet"), scope);
    }

    public static ResultElementBase generateResult(String[] queryTerms, String collectionURI) throws Exception {
        StringBuffer payload = new StringBuffer();
        int[] tf = new int[queryTerms.length];
        int sum = 0;
        for (int i = 0; i < tf.length; ++i) {
            tf[i] = (int)(Math.random() * 100.0);
            sum += tf[i];
        }
        int length = (int)(Math.random() * 1000.0) + sum;
        payload.append("<docFields/>\n");
        payload.append("<docStatistics wc=\"" + length + "\">\n<terms>\n");
        for (int i = 0; i < tf.length; ++i) {
            payload.append("<term name=\"" + queryTerms[i] + "\" tf=\"" + tf[i] + "\"></term>\n");
        }
        float rank = (float)Math.random();
        payload.append("</terms>\n<rank>").append(rank).append("</rank>\n").append("</docStatistics>");
        return new ResultElementGeneric((int)(Math.random() * 10000.0) + "", collectionURI.toString(), "" + rank, payload.toString());
    }
}

