/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.List;
import jodd.JoddProxetta;
import jodd.asm.AnnotationVisitorAdapter;
import jodd.asm.EmptyClassVisitor;
import jodd.asm.EmptyMethodVisitor;
import jodd.asm4.AnnotationVisitor;
import jodd.asm4.MethodVisitor;
import jodd.asm4.Type;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyTarget;
import jodd.proxetta.asm.IntArgHistoryMethodAdapter;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.proxetta.asm.ProxyAspectData;
import jodd.proxetta.asm.TargetMethodData;
import jodd.proxetta.asm.WorkData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxettaMethodBuilder
extends EmptyMethodVisitor {
    public static final String TARGET_CLASS_NAME = ProxyTarget.class.getSimpleName();
    protected final MethodSignatureVisitor msign;
    protected final WorkData wd;
    protected final List<ProxyAspectData> aspectList;
    protected TargetMethodData tmd;
    protected MethodVisitor methodVisitor;

    public ProxettaMethodBuilder(MethodSignatureVisitor msign, WorkData wd, List<ProxyAspectData> aspectList) {
        this.msign = msign;
        this.wd = wd;
        this.aspectList = aspectList;
        this.createFirstChainDelegate_Start();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor destAnn = this.methodVisitor.visitAnnotation(desc, visible);
        return new AnnotationVisitorAdapter(destAnn);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor destAnn = this.methodVisitor.visitAnnotationDefault();
        return new AnnotationVisitorAdapter(destAnn);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitor destAnn = this.methodVisitor.visitParameterAnnotation(parameter, desc, visible);
        return new AnnotationVisitorAdapter(destAnn);
    }

    @Override
    public void visitEnd() {
        this.createFirstChainDelegate_Continue(this.tmd);
        for (int p = 0; p < this.tmd.proxyData.length; ++p) {
            this.tmd.selectCurrentProxy(p);
            this.createProxyMethod(this.tmd);
        }
    }

    protected void createFirstChainDelegate_Start() {
        int access = this.msign.getAccessFlags();
        if ((access & 0x10) != 0) {
            throw new ProxettaException("Unable to create proxy for final method: " + this.msign + ". Remove final modifier or change the pointcut definition.");
        }
        this.tmd = new TargetMethodData(this.msign, this.aspectList);
        access &= 0xFFFFFEFF;
        this.methodVisitor = this.wd.dest.visitMethod(access &= 0xFFFFFBFF, this.tmd.msign.getMethodName(), this.tmd.msign.getDescription(), this.tmd.msign.getRawSignature(), null);
    }

    protected void createFirstChainDelegate_Continue(TargetMethodData tmd) {
        this.methodVisitor.visitCode();
        if (tmd.msign.isStatic) {
            ProxettaAsmUtil.loadStaticMethodArguments(this.methodVisitor, tmd.msign);
            this.methodVisitor.visitMethodInsn(184, this.wd.thisReference, tmd.firstMethodName(), tmd.msign.getDescription());
        } else {
            ProxettaAsmUtil.loadSpecialMethodArguments(this.methodVisitor, tmd.msign);
            this.methodVisitor.visitMethodInsn(183, this.wd.thisReference, tmd.firstMethodName(), tmd.msign.getDescription());
        }
        ProxettaAsmUtil.visitReturn(this.methodVisitor, tmd.msign, false);
        this.methodVisitor.visitMaxs(0, 0);
        this.methodVisitor.visitEnd();
    }

    public void createProxyMethod(final TargetMethodData td) {
        final ProxyAspectData aspectData = td.getProxyData();
        int access = td.msign.getAccessFlags();
        access &= 0xFFFFFEFF;
        access &= 0xFFFFFBFF;
        access = ProxettaAsmUtil.makePrivateFinalAccess(access);
        final MethodVisitor mv = this.wd.dest.visitMethod(access, td.methodName(), td.msign.getDescription(), null, null);
        mv.visitCode();
        aspectData.getAdviceClassReader().accept(new EmptyClassVisitor(){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (!name.equals(JoddProxetta.executeMethodName)) {
                    return null;
                }
                return new IntArgHistoryMethodAdapter(mv){

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if (owner.equals(aspectData.adviceReference)) {
                            owner = ProxettaMethodBuilder.this.wd.thisReference;
                            name = ProxettaAsmUtil.adviceFieldName(name, aspectData.aspectIndex);
                        }
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }

                    public void visitVarInsn(int opcode, int var) {
                        super.visitVarInsn(opcode, var += var == 0 ? 0 : td.msign.getAllArgumentsSize());
                    }

                    public void visitIincInsn(int var, int increment) {
                        super.visitIincInsn(var += var == 0 ? 0 : td.msign.getAllArgumentsSize(), increment);
                    }

                    public void visitInsn(int opcode) {
                        if (opcode == 176) {
                            ProxettaAsmUtil.visitReturn(this.mv, td.msign, true);
                            return;
                        }
                        if (this.traceNext && (opcode == 87 || opcode == 88)) {
                            return;
                        }
                        super.visitInsn(opcode);
                    }

                    public void visitMethodInsn(int opcode, String string, String mname, String mdesc) {
                        if (opcode == 182 || opcode == 185 || opcode == 183) {
                            if (string.equals(aspectData.adviceReference)) {
                                string = ProxettaMethodBuilder.this.wd.thisReference;
                                mname = ProxettaAsmUtil.adviceMethodName(mname, aspectData.aspectIndex);
                            }
                        } else if (opcode == 184) {
                            if (string.equals(aspectData.adviceReference)) {
                                string = ProxettaMethodBuilder.this.wd.thisReference;
                                mname = ProxettaAsmUtil.adviceMethodName(mname, aspectData.aspectIndex);
                            } else if (string.endsWith('/' + TARGET_CLASS_NAME)) {
                                if (ProxettaAsmUtil.isInvokeMethod(mname, mdesc)) {
                                    if (td.isLastMethodInChain()) {
                                        if (!ProxettaMethodBuilder.this.wd.isWrapper()) {
                                            ProxettaAsmUtil.loadSpecialMethodArguments(this.mv, td.msign);
                                            this.mv.visitMethodInsn(183, ProxettaMethodBuilder.this.wd.superReference, td.msign.getMethodName(), td.msign.getDescription());
                                        } else {
                                            this.mv.visitVarInsn(25, 0);
                                            this.mv.visitFieldInsn(180, ProxettaMethodBuilder.this.wd.thisReference, ProxettaMethodBuilder.this.wd.wrapperRef, ProxettaMethodBuilder.this.wd.wrapperType);
                                            ProxettaAsmUtil.loadVirtualMethodArguments(this.mv, td.msign);
                                            if (ProxettaMethodBuilder.this.wd.wrapInterface) {
                                                this.mv.visitMethodInsn(185, ProxettaMethodBuilder.this.wd.wrapperType.substring(1, ProxettaMethodBuilder.this.wd.wrapperType.length() - 1), td.msign.getMethodName(), td.msign.getDescription());
                                            } else {
                                                this.mv.visitMethodInsn(182, ProxettaMethodBuilder.this.wd.wrapperType.substring(1, ProxettaMethodBuilder.this.wd.wrapperType.length() - 1), td.msign.getMethodName(), td.msign.getDescription());
                                            }
                                        }
                                        ProxettaAsmUtil.prepareReturnValue(this.mv, td.msign, aspectData.maxLocalVarOffset);
                                        this.traceNext = true;
                                    } else {
                                        ProxettaAsmUtil.loadSpecialMethodArguments(this.mv, td.msign);
                                        this.mv.visitMethodInsn(183, ProxettaMethodBuilder.this.wd.thisReference, td.nextMethodName(), td.msign.getDescription());
                                        ProxettaAsmUtil.visitReturn(this.mv, td.msign, false);
                                    }
                                    return;
                                }
                                if (ProxettaAsmUtil.isArgumentsCountMethod(mname, mdesc)) {
                                    int argsCount = td.msign.getArgumentsCount();
                                    ProxettaAsmUtil.pushInt(this.mv, argsCount);
                                    return;
                                }
                                if (ProxettaAsmUtil.isArgumentTypeMethod(mname, mdesc)) {
                                    int argIndex = this.getArgumentIndex();
                                    ProxettaAsmUtil.checkArgumentIndex(td.msign, argIndex, aspectData.advice);
                                    this.mv.visitInsn(87);
                                    ProxettaAsmUtil.loadMethodArgumentClass(this.mv, td.msign, argIndex);
                                    return;
                                }
                                if (ProxettaAsmUtil.isArgumentMethod(mname, mdesc)) {
                                    int argIndex = this.getArgumentIndex();
                                    ProxettaAsmUtil.checkArgumentIndex(td.msign, argIndex, aspectData.advice);
                                    this.mv.visitInsn(87);
                                    ProxettaAsmUtil.loadMethodArgumentAsObject(this.mv, td.msign, argIndex);
                                    return;
                                }
                                if (ProxettaAsmUtil.isSetArgumentMethod(mname, mdesc)) {
                                    int argIndex = this.getArgumentIndex();
                                    ProxettaAsmUtil.checkArgumentIndex(td.msign, argIndex, aspectData.advice);
                                    this.mv.visitInsn(87);
                                    ProxettaAsmUtil.storeMethodArgumentFromObject(this.mv, td.msign, argIndex);
                                    return;
                                }
                                if (ProxettaAsmUtil.isCreateArgumentsArrayMethod(mname, mdesc)) {
                                    int argsCount = td.msign.getArgumentsCount();
                                    ProxettaAsmUtil.pushInt(this.mv, argsCount);
                                    this.mv.visitTypeInsn(189, "java/lang/Object");
                                    for (int i = 0; i < argsCount; ++i) {
                                        this.mv.visitInsn(89);
                                        ProxettaAsmUtil.pushInt(this.mv, i);
                                        ProxettaAsmUtil.loadMethodArgumentAsObject(this.mv, td.msign, i + 1);
                                        this.mv.visitInsn(83);
                                    }
                                    return;
                                }
                                if (ProxettaAsmUtil.isCreateArgumentsClassArrayMethod(mname, mdesc)) {
                                    int argsCount = td.msign.getArgumentsCount();
                                    ProxettaAsmUtil.pushInt(this.mv, argsCount);
                                    this.mv.visitTypeInsn(189, "java/lang/Class");
                                    for (int i = 0; i < argsCount; ++i) {
                                        this.mv.visitInsn(89);
                                        ProxettaAsmUtil.pushInt(this.mv, i);
                                        ProxettaAsmUtil.loadMethodArgumentClass(this.mv, td.msign, i + 1);
                                        this.mv.visitInsn(83);
                                    }
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetMethod(mname, mdesc)) {
                                    this.mv.visitVarInsn(25, 0);
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetClassMethod(mname, mdesc)) {
                                    this.mv.visitLdcInsn(Type.getType('L' + ProxettaMethodBuilder.this.wd.superReference + ';'));
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetMethodNameMethod(mname, mdesc)) {
                                    this.mv.visitLdcInsn(td.msign.getMethodName());
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetMethodSignatureMethod(mname, mdesc)) {
                                    this.mv.visitLdcInsn(td.msign.getSignature());
                                    return;
                                }
                                if (ProxettaAsmUtil.isTargetMethodDescriptionMethod(mname, mdesc)) {
                                    this.mv.visitLdcInsn(td.msign.getDescription());
                                    return;
                                }
                                if (ProxettaAsmUtil.isReturnTypeMethod(mname, mdesc)) {
                                    ProxettaAsmUtil.loadMethodReturnClass(this.mv, td.msign);
                                    return;
                                }
                                if (ProxettaAsmUtil.isReturnValueMethod(mname, mdesc)) {
                                    ProxettaAsmUtil.castToReturnType(this.mv, td.msign);
                                    return;
                                }
                            }
                        }
                        super.visitMethodInsn(opcode, string, mname, mdesc);
                    }
                };
            }
        }, 0);
    }
}

