/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.upload;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.MultipartRequest;
import jodd.upload.FileUpload;
import jodd.upload.FileUploadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    MultipartRequest mreq;
    HttpServletRequest req;

    public MultipartRequestWrapper(HttpServletRequest request, FileUploadFactory fileUploadFactory, String encoding) throws IOException {
        super(request);
        this.req = request;
        if (ServletUtil.isMultipartRequest(request)) {
            this.mreq = MultipartRequest.getParsedInstance(request, fileUploadFactory, encoding);
        }
    }

    public MultipartRequestWrapper(HttpServletRequest request, FileUploadFactory fileUploadFactory) throws IOException {
        super(request);
        if (ServletUtil.isMultipartRequest(request)) {
            this.mreq = MultipartRequest.getParsedInstance(request, fileUploadFactory);
        }
    }

    public MultipartRequestWrapper(MultipartRequest mpreq) {
        super(mpreq.getServletRequest());
        this.mreq = mpreq;
    }

    public MultipartRequest getMultipartRequest() {
        return this.mreq;
    }

    public boolean isMultipart() {
        return this.mreq != null;
    }

    public Enumeration<String> getFileParameterNames() {
        if (this.mreq == null) {
            return null;
        }
        return Collections.enumeration(this.mreq.getFileParameterNames());
    }

    public FileUpload[] getFiles(String fieldName) {
        if (this.mreq == null) {
            return null;
        }
        return this.mreq.getFiles(fieldName);
    }

    public FileUpload getFile(String fieldName) {
        if (this.mreq == null) {
            return null;
        }
        return this.mreq.getFile(fieldName);
    }

    public String getParameter(String name) {
        if (this.mreq == null) {
            return super.getParameter(name);
        }
        return this.mreq.getParameter(name);
    }

    public Map getParameterMap() {
        if (this.mreq == null) {
            return super.getParameterMap();
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        if (this.mreq == null) {
            return super.getParameterNames();
        }
        return Collections.enumeration(this.mreq.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        if (this.mreq == null) {
            return super.getParameterValues(name);
        }
        return this.mreq.getParameterValues(name);
    }
}

