/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.channel.rendezvous;

import java.io.IOException;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.Channel;
import org.walluck.oscar.handlers.SNACHandler;

public abstract class Rendezvous
extends Channel {
    public static final int TYPE_REQUEST = 0;
    public static final int TYPE_CANCEL = 1;
    public static final int TYPE_ACCEPT = 2;
    public static final int ERROR_CODE_NOT_SUPPORTED = 0;
    public static final int ERROR_CODE_DECLINED = 1;
    public static final int ERROR_CODE_NOT_ACCEPTING = 2;
    public static final int TLV_TYPE_UNKNOWN0001 = 1;
    public static final int TLV_TYPE_IP_ADDRRESS = 2;
    public static final int TLV_TYPE_MY_IP_ADDRESS = 3;
    public static final int TLV_TYPE_VERIFIED_IP_ADDR = 4;
    public static final int TLV_TYPE_PORT = 5;
    public static final int TLV_TYPE_INVITATION_MESSAGE = 6;
    public static final int TLV_TYPE_GAMES_URL = 7;
    public static final int TLV_TYPE_OTHER_URL = 8;
    public static final int TLV_TYPE_UNKNOWN0009 = 9;
    public static final int TLV_TYPE_REQUEST_TYPE = 10;
    public static final int TLV_TYPE_ERROR_CODE = 11;
    public static final int TLV_TYPE_CHAT_MESSAGE = 12;
    public static final int TLV_TYPE_ENCODING = 13;
    public static final int TLV_TYPE_LANGUAGE = 14;
    public static final int TLV_TYPE_UNKNOWN000F = 15;
    public static final int TLV_TYPE_PROXY = 16;
    public static final int TLV_TYPE_SECURE = 17;
    private int type;
    private byte[] cookie;
    private int service;
    private TLVChain serviceData;
    private int errorCode = -1;

    public Rendezvous() {
        this.setChannel(2);
    }

    public abstract void setRequest() throws IOException;

    public void setCancel() throws IOException {
        this.setType(1);
    }

    public void setAccept() throws IOException {
        this.setType(2);
    }

    public void setError() throws IOException {
        this.setType(1);
        if (this.errorCode != -1) {
            TLVChain tlvchain = new TLVChain(1);
            tlvchain.addShort(11, this.errorCode);
            this.setServiceData(tlvchain);
        }
    }

    public abstract void handleServiceData(AIMSession var1, SNACHandler var2, AIMFrame var3, SNAC var4, UserInfo var5, IncomingIMCH2 var6, AIMInputStream var7) throws IOException;

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public int getService() {
        return this.service;
    }

    public void setService(int service) {
        this.service = service;
    }

    public TLVChain getServiceData() {
        return this.serviceData;
    }

    public void setServiceData(TLVChain serviceData) {
        this.serviceData = serviceData;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }
}

