/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams;

import org.gcube.data.streams.Callback;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.exceptions.StreamSkipSignal;
import org.gcube.data.streams.exceptions.StreamStopSignal;

public final class StreamConsumer<T> {
    private final Stream<T> stream;
    private final Callback<T> callback;

    public StreamConsumer(Stream<T> stream, Callback<T> callback) {
        this.stream = stream;
        this.callback = callback;
    }

    public void start() {
        this.consume();
    }

    private void consume() {
        try {
            while (this.stream.hasNext()) {
                T next = this.stream.next();
                try {
                    this.callback.consume(next);
                }
                catch (StreamSkipSignal skip) {
                }
                catch (StreamStopSignal stop) {
                    break;
                }
            }
        }
        finally {
            this.stream.close();
        }
    }
}

