/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.publishers;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.Utils;
import org.gcube.data.streams.exceptions.StreamPublishException;
import org.gcube.data.streams.exceptions.StreamSkipSignal;
import org.gcube.data.streams.exceptions.StreamStopSignal;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.streams.handlers.FaultHandler;
import org.gcube.data.streams.handlers.RethrowHandler;
import org.gcube.data.streams.publishers.RecordFactory;
import org.gcube.data.streams.publishers.RsStringRecordFactory;
import org.gcube.data.streams.publishers.RsTransport;
import org.gcube.data.streams.publishers.StreamPublisher;
import org.gcube.data.streams.publishers.ThreadProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsPublisher<E>
implements StreamPublisher {
    private static Logger log = LoggerFactory.getLogger(RsPublisher.class);
    private final Stream<E> stream;
    private final RecordFactory<E> factory;
    private RsTransport transport;
    private int bufferSize = RecordWriter.DefaultBufferCapacity;
    private long timeout = RecordWriter.DefaultInactivityTimeout;
    private TimeUnit timeoutUnit = RecordWriter.DefaultInactivityTimeUnit;
    private boolean onDemand = true;
    private ThreadProvider provider = new ThreadProvider(){

        @Override
        public Thread newThread(Runnable task) {
            return new Thread(task);
        }
    };
    private FaultHandler handler = new RethrowHandler();

    public RsPublisher(Stream<E> stream, Generator<E, String> serialiser) {
        this(stream, new RsStringRecordFactory<E>(serialiser));
    }

    public RsPublisher(Stream<E> stream, RecordFactory<E> factory) {
        if (stream == null || factory == null || factory.definitions() == null) {
            throw new IllegalArgumentException("invalid or null inputs");
        }
        this.stream = stream;
        this.factory = factory;
    }

    public void setBufferSize(int size) throws IllegalArgumentException {
        if (size <= 0) {
            throw new IllegalArgumentException("invalid empty buffer");
        }
        this.bufferSize = size;
    }

    public void setTimeout(long timeout, TimeUnit timeoutUnit) throws IllegalArgumentException {
        if (timeout <= 0L || timeoutUnit == null) {
            throw new IllegalArgumentException("invalid  timeout or time unit");
        }
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    public void setTransport(RsTransport transport) {
        if (transport == null) {
            throw new IllegalArgumentException("invalid null transport");
        }
        this.transport = transport;
    }

    public void setOnDemand(boolean onDemand) {
        this.onDemand = onDemand;
    }

    public void setThreadProvider(ThreadProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("invalid null provider");
        }
        this.provider = provider;
    }

    public void setFaultHandler(FaultHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("invalid null handler");
        }
        this.handler = handler;
    }

    @Override
    public URI publish() throws StreamPublishException {
        URI locator;
        RecordWriter writer;
        Utils.initialiseRS();
        if (this.transport == null) {
            this.transport = RsTransport.TCP;
        }
        try {
            writer = new RecordWriter(this.transport.proxy(), this.factory.definitions(), this.bufferSize, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor, this.timeout, this.timeoutUnit);
            locator = writer.getLocator();
        }
        catch (GRS2WriterException e) {
            throw new StreamPublishException("cannot publish stream as resultset", e);
        }
        Runnable feeder = this.newFeeder((RecordWriter<Record>)writer, locator);
        this.provider.newThread(feeder).start();
        return locator;
    }

    private Runnable newFeeder(final RecordWriter<Record> writer, final URI locator) {
        return new Runnable(){

            @Override
            public void run() {
                while (RsPublisher.this.stream.hasNext()) {
                    try {
                        RsPublisher.this.publishNextElementOrFailure((RecordWriter<Record>)writer);
                    }
                    catch (RuntimeException e) {
                        if (RsPublisher.this.onDemand) break;
                        RsPublisher.this.close((RecordWriter<Record>)writer, locator);
                    }
                }
                RsPublisher.this.close((RecordWriter<Record>)writer, locator);
                RsPublisher.this.stream.close();
            }
        };
    }

    private void publishNextElementOrFailure(RecordWriter<Record> writer) {
        try {
            try {
                this.publish(writer, this.nextRecord());
            }
            catch (StreamSkipSignal skip) {
                return;
            }
            catch (StreamStopSignal stop) {
                throw stop;
            }
            catch (RuntimeException failure) {
                this.publish(writer, failure);
                if (!Utils.isContingency(failure)) {
                    throw failure;
                }
            }
        }
        catch (GRS2WriterException failure) {
            throw new RuntimeException(failure);
        }
    }

    private Record nextRecord() {
        try {
            E element = this.stream.next();
            return this.factory.newRecord(element);
        }
        catch (RuntimeException e) {
            try {
                this.handler.handle(e);
            }
            catch (StreamStopSignal stop) {
                throw e;
            }
            throw new StreamSkipSignal();
        }
    }

    private void publish(RecordWriter<Record> writer, Record record) throws GRS2WriterException {
        if (writer.getStatus() == IBuffer.Status.Open) {
            if (!writer.put(record, this.timeout, this.timeoutUnit)) {
                log.trace("client is not consuming resulset, stop publishing");
                throw new GRS2WriterException();
            }
        } else {
            log.warn("Writer not open, actual status is {}", (Object)writer.getStatus());
            throw new GRS2WriterException("writer closed or disposed");
        }
    }

    private void publish(RecordWriter<Record> writer, Throwable failure) throws GRS2WriterException {
        if (writer.getStatus() == IBuffer.Status.Open && !writer.put(failure, this.timeout, this.timeoutUnit)) {
            log.trace("client is not consuming resulset, stop publishing");
            throw new GRS2WriterException();
        }
    }

    private void close(RecordWriter<Record> writer, URI locator) {
        if (writer.getStatus() == IBuffer.Status.Open) {
            try {
                writer.close();
            }
            catch (GRS2WriterException e) {
                log.error("error closing resultset at " + locator, (Throwable)e);
            }
        }
    }
}

