/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.xsl;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class QueuingContentHandler
implements ContentHandler {
    private LinkedList events = null;
    private ContentHandler contentHandler = null;
    private boolean queuing = false;
    private Object lock = new Object();

    public QueuingContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Callable callable) throws SAXException {
        Object object = this.lock;
        synchronized (object) {
            if (this.queuing) {
                this.events.addLast(callable);
            } else {
                this.run(callable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Callable callable) throws SAXException {
        Object object = this.lock;
        synchronized (object) {
            try {
                callable.call();
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopQueuing() throws SAXException {
        Object object = this.lock;
        synchronized (object) {
            while (this.events.size() > 0) {
                Callable callable = (Callable)this.events.removeFirst();
                this.run(callable);
            }
            this.queuing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startQueuing() throws SAXException {
        Object object = this.lock;
        synchronized (object) {
            this.queuing = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDocument() throws SAXException {
        Object object = this.lock;
        synchronized (object) {
            this.events = new LinkedList();
        }
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.startDocument();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws SAXException {
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.endDocument();
                return null;
            }
        });
        Object object = this.lock;
        synchronized (object) {
            if (this.queuing) {
                this.stopQueuing();
                this.startQueuing();
            }
        }
    }

    public void characters(char[] ch, int start, final int length) throws SAXException {
        final char[] copy = new char[length];
        System.arraycopy(ch, start, copy, 0, length);
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.characters(copy, 0, length);
                return null;
            }
        });
    }

    public void ignorableWhitespace(char[] ch, int start, final int length) throws SAXException {
        final char[] copy = new char[length];
        System.arraycopy(ch, start, copy, 0, length);
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.ignorableWhitespace(copy, 0, length);
                return null;
            }
        });
    }

    public void endPrefixMapping(final String prefix) throws SAXException {
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.endPrefixMapping(prefix);
                return null;
            }
        });
    }

    public void skippedEntity(final String name) throws SAXException {
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.skippedEntity(name);
                return null;
            }
        });
    }

    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    public void processingInstruction(final String target, final String data) throws SAXException {
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.processingInstruction(target, data);
                return null;
            }
        });
    }

    public void startPrefixMapping(final String prefix, final String uri) throws SAXException {
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.startPrefixMapping(prefix, uri);
                return null;
            }
        });
    }

    public void endElement(final String namespaceURI, final String localName, final String qName) throws SAXException {
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.endElement(namespaceURI, localName, qName);
                return null;
            }
        });
    }

    public void startElement(final String namespaceURI, final String localName, final String qName, final Attributes atts) throws SAXException {
        this.enqueue(new Callable(){

            public Object call() throws Exception {
                QueuingContentHandler.this.contentHandler.startElement(namespaceURI, localName, qName, atts);
                return null;
            }
        });
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }
}

