/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.cext.Cleaner;
import org.jruby.cext.GC;
import org.jruby.cext.Handle;
import org.jruby.cext.Native;

public class RubyData
extends RubyObject {
    private RubyData(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    public static RubyData newRubyData(Ruby runtime2, RubyClass klass, long handle) {
        RubyData d = new RubyData(runtime2, klass);
        GC.register(d, Handle.newHandle(runtime2, d, handle));
        Cleaner.register(new DataCleaner(d, handle));
        return d;
    }

    static final class DataCleaner
    extends Cleaner {
        private final long address;

        public DataCleaner(RubyData obj, long address2) {
            super(obj);
            this.address = address2;
        }

        void dispose() {
            Native.freeHandle(this.address);
        }
    }
}

