/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtil {
    public static final String ARRAY_NOTATION = "[]";
    public static final String[] ARRAYS = new String[]{"array", "[]"};
    public static final String BOOLEAN = "boolean";
    public static final String[] BOOLEANS = new String[]{"boolean", "bool"};
    public static final String DOUBLE = "double";
    public static final String[] DOUBLES = new String[]{"double"};
    public static final String FLOAT = "float";
    public static final String[] FLOATS = new String[]{"float"};
    public static final String INT = "int";
    public static final String[] INTEGERS = new String[]{"integer", "int", "int | string"};
    public static final String LONG = "long";
    public static final String[] LONGS = new String[]{"long"};
    public static final String[] NUMBERS = new String[]{"num", "number"};
    public static final String[] OBJECTS = new String[]{"object", "{}"};
    public static final String SHORT = "short";
    public static final String[] SHORTS = new String[]{"short"};
    public static final String[] STRINGS = new String[]{"node | string", "string", "string | node", "string | int"};
    private static HashMap<String, String> _INPUT_TYPES = null;
    private static HashMap<String, String> _OUTPUT_TYPES = null;
    private static TypeUtil _instance = new TypeUtil();

    public static String getInputJavaType(String type, boolean removeGenericsType) {
        return _instance._getInputJavaType(type, removeGenericsType);
    }

    public static TypeUtil getInstance() {
        return _instance;
    }

    public static String getOutputJavaType(String type, boolean removeGenericsType) {
        return _instance._getOutputJavaType(type, removeGenericsType);
    }

    public static boolean hasMethod(String className, String methodName, String[] paramTypes) {
        return _instance._hasMethod(className, methodName, paramTypes);
    }

    public static boolean isJavaClass(String className) {
        return _instance._isJavaClass(className);
    }

    public static boolean isPrimitiveType(String type) {
        return BOOLEAN.equals(type) || DOUBLE.equals(type) || FLOAT.equals(type) || INT.equals(type) || LONG.equals(type) || SHORT.equals(type);
    }

    private TypeUtil() {
        _INPUT_TYPES = new HashMap();
        _OUTPUT_TYPES = new HashMap();
        this._registerTypes(_INPUT_TYPES, ARRAYS, Object.class.getName());
        this._registerTypes(_INPUT_TYPES, BOOLEANS, Boolean.TYPE.getName());
        this._registerTypes(_INPUT_TYPES, FLOATS, Float.TYPE.getName());
        this._registerTypes(_INPUT_TYPES, INTEGERS, Integer.TYPE.getName());
        this._registerTypes(_INPUT_TYPES, DOUBLES, Double.TYPE.getName());
        this._registerTypes(_INPUT_TYPES, LONGS, Long.TYPE.getName());
        this._registerTypes(_INPUT_TYPES, SHORTS, Short.TYPE.getName());
        this._registerTypes(_INPUT_TYPES, NUMBERS, Object.class.getName());
        this._registerTypes(_INPUT_TYPES, OBJECTS, Object.class.getName());
        this._registerTypes(_INPUT_TYPES, STRINGS, String.class.getName());
        this._registerTypes(_OUTPUT_TYPES, ARRAYS, ArrayList.class.getName());
        this._registerTypes(_OUTPUT_TYPES, BOOLEANS, Boolean.TYPE.getName());
        this._registerTypes(_OUTPUT_TYPES, FLOATS, Float.TYPE.getName());
        this._registerTypes(_OUTPUT_TYPES, INTEGERS, Integer.TYPE.getName());
        this._registerTypes(_OUTPUT_TYPES, DOUBLES, Double.TYPE.getName());
        this._registerTypes(_OUTPUT_TYPES, LONGS, Long.TYPE.getName());
        this._registerTypes(_OUTPUT_TYPES, SHORTS, Short.TYPE.getName());
        this._registerTypes(_OUTPUT_TYPES, NUMBERS, Number.class.getName());
        this._registerTypes(_OUTPUT_TYPES, OBJECTS, HashMap.class.getName());
        this._registerTypes(_OUTPUT_TYPES, STRINGS, String.class.getName());
    }

    private Class<?> _getClass(String className) {
        Class clazz = null;
        try {
            clazz = ClassUtils.getClass((String)className);
        }
        catch (ClassNotFoundException e) {
            if (this._isJavaClass(className)) {
                String genericsType = this._getGenericsType(className);
                if (Validator.isNotNull((String)genericsType)) {
                    className = this._removeGenericsType(className);
                    return this._getClass(className);
                }
            }
            e.printStackTrace();
        }
        return clazz;
    }

    private String _getGenericsType(String type) {
        int begin = type.indexOf(60);
        int end = type.indexOf(62);
        String genericsType = null;
        if (begin > -1 && end > -1) {
            genericsType = type.substring(begin + 1, end);
        }
        return genericsType;
    }

    private String _getInputJavaType(String type, boolean removeGenericsType) {
        if (removeGenericsType) {
            type = this._removeGenericsType(type);
        }
        if (this._isJavaClass(type)) {
            return type;
        }
        String javaType = _INPUT_TYPES.get(type.toLowerCase());
        if (Validator.isNull((String)javaType)) {
            javaType = Object.class.getName();
        }
        return javaType;
    }

    private String _getOutputJavaType(String type, boolean removeGenericsType) {
        if (removeGenericsType) {
            type = this._removeGenericsType(type);
        }
        if (this._isJavaClass(type)) {
            return type;
        }
        String javaType = _OUTPUT_TYPES.get(type.toLowerCase());
        if (Validator.isNull((String)javaType)) {
            javaType = Object.class.getName();
        }
        return javaType;
    }

    private boolean _hasMethod(String className, String methodName, String[] paramTypes) {
        Class<?> javaClass = this._getClass(className);
        if (javaClass == null) {
            return false;
        }
        for (Class<?> superClass = javaClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            boolean superClassHasMethod = this._hasMethod(superClass.getName(), methodName, paramTypes);
            if (!superClassHasMethod) continue;
            return true;
        }
        Class[] parameterTypes = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = this._getClass(paramTypes[i]);
            if (paramType == null) {
                return false;
            }
            parameterTypes[i] = paramType;
        }
        Method method = null;
        try {
            method = javaClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method != null;
    }

    private boolean _isJavaClass(String className) {
        if (TypeUtil.isPrimitiveType(className)) {
            return true;
        }
        try {
            String genericsType = this._getGenericsType(className);
            if (Validator.isNotNull((String)genericsType)) {
                String[] genericsTypes = StringUtil.split((String)genericsType);
                for (int i = 0; i < genericsTypes.length; ++i) {
                    String curType = genericsTypes[i].trim();
                    if (curType.equals("?")) continue;
                    Class.forName(this._removeArrayNotation(curType));
                }
                className = this._removeGenericsType(className);
            }
            Class.forName(this._removeArrayNotation(className));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void _registerTypes(HashMap<String, String> map, String[] types, String javaType) {
        for (String type : types) {
            map.put(type.toLowerCase(), javaType);
        }
    }

    private String _removeArrayNotation(String type) {
        return type.replace(ARRAY_NOTATION, "");
    }

    private String _removeGenericsType(String type) {
        String genericsType = this._getGenericsType(type);
        if (Validator.isNotNull((String)genericsType)) {
            type = type.replace("<".concat(genericsType).concat(">"), "");
        }
        return type;
    }
}

