/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.Pair;

public class KeyCacheKey
extends Pair<Descriptor, ByteBuffer>
implements CacheKey {
    public KeyCacheKey(Descriptor desc, ByteBuffer key) {
        super(desc, key);
    }

    @Override
    public ByteBuffer serializeForStorage() {
        ByteBuffer bytes = ByteBuffer.allocate(this.serializedSize());
        bytes.put(((ByteBuffer)this.right).slice());
        bytes.rewind();
        return bytes;
    }

    @Override
    public Pair<String, String> getPathInfo() {
        return new Pair<String, String>(((Descriptor)this.left).ksname, ((Descriptor)this.left).cfname);
    }

    @Override
    public int serializedSize() {
        return ((ByteBuffer)this.right).remaining();
    }

    @Override
    public String toString() {
        return String.format("KeyCacheKey(descriptor:%s, key:%s)", this.left, this.right);
    }
}

