/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Term;

public class Relation {
    private final ColumnIdentifier entity;
    private final Type relationType;
    private final Term value;
    private final List<Term> inValues;

    private Relation(ColumnIdentifier entity, Type type, Term value, List<Term> inValues) {
        this.entity = entity;
        this.relationType = type;
        this.value = value;
        this.inValues = inValues;
    }

    public Relation(ColumnIdentifier entity, String type, Term value) {
        this(entity, Type.forString(type), value, null);
    }

    public static Relation createInRelation(ColumnIdentifier entity) {
        return new Relation(entity, Type.IN, null, new ArrayList<Term>());
    }

    public Type operator() {
        return this.relationType;
    }

    public ColumnIdentifier getEntity() {
        return this.entity;
    }

    public Term getValue() {
        assert (this.relationType != Type.IN);
        return this.value;
    }

    public List<Term> getInValues() {
        assert (this.relationType == Type.IN);
        return this.inValues;
    }

    public void addInValue(Term t) {
        this.inValues.add(t);
    }

    public String toString() {
        if (this.relationType == Type.IN) {
            return String.format("%s IN %s", this.entity, this.inValues);
        }
        return String.format("%s %s %s", new Object[]{this.entity, this.relationType, this.value});
    }

    public static enum Type {
        EQ,
        LT,
        LTE,
        GTE,
        GT,
        IN;


        public static Type forString(String s) {
            if (s.equals("=")) {
                return EQ;
            }
            if (s.equals("<")) {
                return LT;
            }
            if (s.equals("<=")) {
                return LTE;
            }
            if (s.equals(">=")) {
                return GTE;
            }
            if (s.equals(">")) {
                return GT;
            }
            return null;
        }
    }
}

