/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.RequestType;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.utils.Pair;

public class BatchStatement
extends ModificationStatement {
    protected final List<ModificationStatement> statements;

    public BatchStatement(List<ModificationStatement> statements, Attributes attrs) {
        super(null, attrs);
        this.statements = statements;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.prepareKeyspace(state);
        }
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
        HashSet<String> cfamsSeen = new HashSet<String>();
        for (ModificationStatement statement : this.statements) {
            if (cfamsSeen.contains(statement.columnFamily())) continue;
            state.hasColumnFamilyAccess(statement.keyspace(), statement.columnFamily(), Permission.WRITE);
            cfamsSeen.add(statement.columnFamily());
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.getTimeToLive() != 0) {
            throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
        }
        for (ModificationStatement statement : this.statements) {
            if (statement.isSetConsistencyLevel()) {
                throw new InvalidRequestException("Consistency level must be set on the BATCH, not individual statements");
            }
            if (this.isSetTimestamp() && statement.isSetTimestamp()) {
                throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
            }
            if (statement.getTimeToLive() < 0) {
                throw new InvalidRequestException("A TTL must be greater or equal to 0");
            }
            ThriftValidation.validateConsistencyLevel(statement.keyspace(), this.getConsistencyLevel(), RequestType.WRITE);
        }
    }

    @Override
    public List<IMutation> getMutations(ClientState clientState, List<ByteBuffer> variables) throws InvalidRequestException {
        HashMap<Pair<String, ByteBuffer>, RowAndCounterMutation> mutations = new HashMap<Pair<String, ByteBuffer>, RowAndCounterMutation>();
        for (ModificationStatement statement : this.statements) {
            if (this.isSetTimestamp()) {
                statement.timestamp = this.timestamp;
            }
            List<IMutation> lm = statement.getMutations(clientState, variables);
            for (IMutation m : lm) {
                Pair<String, ByteBuffer> key = Pair.create(m.getTable(), m.key());
                RowAndCounterMutation racm = (RowAndCounterMutation)mutations.get(key);
                if (racm == null) {
                    racm = new RowAndCounterMutation();
                    mutations.put(key, racm);
                }
                if (m instanceof CounterMutation) {
                    if (racm.cm == null) {
                        racm.cm = (CounterMutation)m;
                        continue;
                    }
                    racm.cm.addAll(m);
                    continue;
                }
                assert (m instanceof RowMutation);
                if (racm.rm == null) {
                    racm.rm = (RowMutation)m;
                    continue;
                }
                racm.rm.addAll(m);
            }
        }
        LinkedList<IMutation> batch = new LinkedList<IMutation>();
        for (RowAndCounterMutation racm : mutations.values()) {
            if (racm.rm != null) {
                batch.add(racm.rm);
            }
            if (racm.cm == null) continue;
            batch.add(racm.cm);
        }
        return batch;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        ArrayList boundTypes = new ArrayList();
        for (ModificationStatement statement : this.statements) {
            boundTypes.addAll(statement.prepare().boundTypes);
        }
        return new ParsedStatement.Prepared(this, boundTypes);
    }

    public String toString() {
        return String.format("BatchStatement(statements=%s, consistency=%s)", this.statements, this.cLevel);
    }

    private static class RowAndCounterMutation {
        public RowMutation rm;
        public CounterMutation cm;

        private RowAndCounterMutation() {
        }
    }
}

