/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.SnapshotCommand;
import org.apache.cassandra.io.IVersionedSerializer;

class SnapshotCommandSerializer
implements IVersionedSerializer<SnapshotCommand> {
    SnapshotCommandSerializer() {
    }

    @Override
    public void serialize(SnapshotCommand snapshot_command, DataOutput dos, int version) throws IOException {
        dos.writeUTF(snapshot_command.keyspace);
        dos.writeUTF(snapshot_command.column_family);
        dos.writeUTF(snapshot_command.snapshot_name);
        dos.writeBoolean(snapshot_command.clear_snapshot);
    }

    @Override
    public SnapshotCommand deserialize(DataInput dis, int version) throws IOException {
        String keyspace = dis.readUTF();
        String column_family = dis.readUTF();
        String snapshot_name = dis.readUTF();
        boolean clear_snapshot = dis.readBoolean();
        return new SnapshotCommand(keyspace, column_family, snapshot_name, clear_snapshot);
    }

    @Override
    public long serializedSize(SnapshotCommand snapshot_command, int version) {
        throw new UnsupportedOperationException();
    }
}

