/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.compaction.OperationType;

public final class CompactionInfo
implements Serializable {
    private static final long serialVersionUID = 3695381572726744816L;
    private final int id;
    private final String ksname;
    private final String cfname;
    private final OperationType tasktype;
    private final long bytesComplete;
    private final long totalBytes;

    public CompactionInfo(int id, String ksname, String cfname, OperationType tasktype, long bytesComplete, long totalBytes) {
        this.id = id;
        this.ksname = ksname;
        this.cfname = cfname;
        this.tasktype = tasktype;
        this.bytesComplete = bytesComplete;
        this.totalBytes = totalBytes;
    }

    public CompactionInfo forProgress(long bytesComplete, long totalBytes) {
        return new CompactionInfo(this.id, this.ksname, this.cfname, this.tasktype, bytesComplete, totalBytes);
    }

    public int getId() {
        return this.id;
    }

    public String getKeyspace() {
        return this.ksname;
    }

    public String getColumnFamily() {
        return this.cfname;
    }

    public long getBytesComplete() {
        return this.bytesComplete;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public OperationType getTaskType() {
        return this.tasktype;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append((Object)this.getTaskType()).append('@').append(this.id);
        buff.append('(').append(this.getKeyspace()).append(", ").append(this.getColumnFamily());
        buff.append(", ").append(this.getBytesComplete()).append('/').append(this.getTotalBytes());
        return buff.append(')').toString();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("id", Integer.toString(this.id));
        ret.put("keyspace", this.ksname);
        ret.put("columnfamily", this.cfname);
        ret.put("bytesComplete", Long.toString(this.bytesComplete));
        ret.put("totalBytes", Long.toString(this.totalBytes));
        ret.put("taskType", this.tasktype.toString());
        return ret;
    }

    public static abstract class Holder {
        private volatile boolean isStopped = false;

        public abstract CompactionInfo getCompactionInfo();

        public void stop() {
            this.isStopped = true;
        }

        public boolean isStopped() {
            return this.isStopped;
        }
    }
}

