/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.Pair;

public abstract class AbstractBounds<T extends RingPosition>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static AbstractBoundsSerializer serializer = new AbstractBoundsSerializer();
    public final T left;
    public final T right;
    protected final transient IPartitioner partitioner;

    public static AbstractBoundsSerializer serializer() {
        return serializer;
    }

    public AbstractBounds(T left, T right, IPartitioner partitioner) {
        this.left = left;
        this.right = right;
        this.partitioner = partitioner;
    }

    public abstract Pair<AbstractBounds<T>, AbstractBounds<T>> split(T var1);

    public int hashCode() {
        return 31 * this.left.hashCode() + this.right.hashCode();
    }

    public abstract boolean contains(T var1);

    public abstract List<? extends AbstractBounds<T>> unwrap();

    public abstract AbstractBounds<RowPosition> toRowBounds();

    public abstract AbstractBounds<Token> toTokenBounds();

    public static class AbstractBoundsSerializer
    implements IVersionedSerializer<AbstractBounds<?>> {
        @Override
        public void serialize(AbstractBounds<?> range, DataOutput out, int version) throws IOException {
            int kind;
            if (version < 4) {
                range = range.toTokenBounds();
            }
            boolean isToken = range.left instanceof Token;
            int n = kind = range instanceof Range ? Type.RANGE.ordinal() : Type.BOUNDS.ordinal();
            if (!isToken) {
                kind = -(kind + 1);
            }
            out.writeInt(kind);
            if (isToken) {
                Token.serializer().serialize((Token)range.left, out);
                Token.serializer().serialize((Token)range.right, out);
            } else {
                RowPosition.serializer().serialize((RowPosition)range.left, out);
                RowPosition.serializer().serialize((RowPosition)range.right, out);
            }
        }

        @Override
        public AbstractBounds<?> deserialize(DataInput in, int version) throws IOException {
            RingPosition right;
            RingPosition left;
            boolean isToken;
            int kind = in.readInt();
            boolean bl = isToken = kind >= 0;
            if (!isToken) {
                kind = -(kind + 1);
            }
            if (isToken) {
                left = Token.serializer().deserialize(in);
                right = Token.serializer().deserialize(in);
            } else {
                left = RowPosition.serializer().deserialize(in);
                right = RowPosition.serializer().deserialize(in);
            }
            if (kind == Type.RANGE.ordinal()) {
                return new Range<Token>((Token)left, (Token)right);
            }
            return new Bounds<Token>((Token)left, (Token)right);
        }

        @Override
        public long serializedSize(AbstractBounds<?> abstractBounds, int version) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum Type {
        RANGE,
        BOUNDS;

    }
}

