/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.ObjectUtils;

public class Range<T extends RingPosition>
extends AbstractBounds<T>
implements Comparable<Range<T>>,
Serializable {
    public static final long serialVersionUID = 1L;

    public Range(T left, T right) {
        this(left, right, StorageService.getPartitioner());
    }

    public Range(T left, T right, IPartitioner partitioner) {
        super(left, right, partitioner);
    }

    public static <T extends RingPosition> boolean contains(T left, T right, T bi) {
        if (Range.isWrapAround(left, right)) {
            if (bi.compareTo(left) > 0) {
                return true;
            }
            return right.compareTo(bi) >= 0;
        }
        return bi.compareTo(left) > 0 && right.compareTo(bi) >= 0;
    }

    @Override
    public boolean contains(Range<T> that) {
        boolean thatwraps;
        if (this.left.equals(this.right)) {
            return true;
        }
        boolean thiswraps = Range.isWrapAround(this.left, this.right);
        if (thiswraps == (thatwraps = Range.isWrapAround(that.left, that.right))) {
            return this.left.compareTo(that.left) <= 0 && that.right.compareTo(this.right) <= 0;
        }
        if (thiswraps) {
            return this.left.compareTo(that.left) <= 0 || that.right.compareTo(this.right) <= 0;
        }
        return false;
    }

    @Override
    public boolean contains(T bi) {
        return Range.contains(this.left, this.right, bi);
    }

    public boolean intersects(Range<T> that) {
        return this.intersectionWith(that).size() > 0;
    }

    public static <T extends RingPosition> Set<Range<T>> rangeSet(Range<T> ... ranges) {
        return Collections.unmodifiableSet(new HashSet<Range<T>>(Arrays.asList(ranges)));
    }

    public static <T extends RingPosition> Set<Range<T>> rangeSet(Range<T> range) {
        return Collections.singleton(range);
    }

    public Set<Range<T>> intersectionWith(Range<T> that) {
        if (that.contains(this)) {
            return Range.rangeSet(this);
        }
        if (this.contains((T)that)) {
            return Range.rangeSet(that);
        }
        boolean thiswraps = Range.isWrapAround(this.left, this.right);
        boolean thatwraps = Range.isWrapAround(that.left, that.right);
        if (!thiswraps && !thatwraps) {
            if (this.left.compareTo(that.right) >= 0 || that.left.compareTo(this.right) >= 0) {
                return Collections.emptySet();
            }
            return Range.rangeSet(new Range<RingPosition>((RingPosition)ObjectUtils.max((Comparable)this.left, (Comparable)that.left), (RingPosition)ObjectUtils.min((Comparable)this.right, (Comparable)that.right), this.partitioner));
        }
        if (thiswraps && thatwraps) {
            assert (!this.left.equals(that.left));
            return this.left.compareTo(that.left) < 0 ? Range.intersectionBothWrapping(this, that) : Range.intersectionBothWrapping(that, this);
        }
        if (thiswraps && !thatwraps) {
            return Range.intersectionOneWrapping(this, that);
        }
        assert (!thiswraps && thatwraps);
        return Range.intersectionOneWrapping(that, this);
    }

    private static <T extends RingPosition> Set<Range<T>> intersectionBothWrapping(Range<T> first, Range<T> that) {
        HashSet<Range<RingPosition>> intersection = new HashSet<Range<RingPosition>>(2);
        if (that.right.compareTo(first.left) > 0) {
            intersection.add(new Range<RingPosition>(first.left, that.right, first.partitioner));
        }
        intersection.add(new Range<RingPosition>(that.left, first.right, first.partitioner));
        return Collections.unmodifiableSet(intersection);
    }

    private static <T extends RingPosition> Set<Range<T>> intersectionOneWrapping(Range<T> wrapping, Range<T> other) {
        HashSet<Range<RingPosition>> intersection = new HashSet<Range<RingPosition>>(2);
        if (other.contains(wrapping.right)) {
            intersection.add(new Range<RingPosition>(other.left, wrapping.right, wrapping.partitioner));
        }
        if (other.contains(wrapping.left) && wrapping.left.compareTo(other.right) < 0) {
            intersection.add(new Range<RingPosition>(wrapping.left, other.right, wrapping.partitioner));
        }
        return Collections.unmodifiableSet(intersection);
    }

    @Override
    public Pair<AbstractBounds<T>, AbstractBounds<T>> split(T position) {
        assert (this.contains(position) || this.left.equals(position));
        if (position.equals(this.left) || position.equals(this.right)) {
            return null;
        }
        Range<RingPosition> lb = new Range<RingPosition>(this.left, (RingPosition)position, this.partitioner);
        Range<RingPosition> rb = new Range<RingPosition>((RingPosition)position, this.right, this.partitioner);
        return new Pair<AbstractBounds<T>, AbstractBounds<T>>(lb, rb);
    }

    @Override
    public List<Range<T>> unwrap() {
        Object minValue = this.partitioner.minValue(this.right.getClass());
        if (!this.isWrapAround() || this.right.equals(minValue)) {
            return Arrays.asList(this);
        }
        ArrayList<Range<T>> unwrapped = new ArrayList<Range<T>>(2);
        unwrapped.add(new Range<RingPosition>(this.left, (RingPosition)minValue, this.partitioner));
        unwrapped.add(new Range<RingPosition>((RingPosition)minValue, this.right, this.partitioner));
        return unwrapped;
    }

    public static <T extends RingPosition> boolean isWrapAround(T left, T right) {
        return left.compareTo(right) >= 0;
    }

    @Override
    public int compareTo(Range<T> rhs) {
        if (Range.isWrapAround(this.left, this.right)) {
            return -1;
        }
        if (Range.isWrapAround(rhs.left, rhs.right)) {
            return 1;
        }
        return this.right.compareTo(rhs.right);
    }

    private ArrayList<Range<T>> subtractContained(Range<T> contained) {
        ArrayList<Range<T>> difference = new ArrayList<Range<T>>();
        if (!this.left.equals(contained.left)) {
            difference.add(new Range<RingPosition>(this.left, contained.left, this.partitioner));
        }
        if (!this.right.equals(contained.right)) {
            difference.add(new Range<RingPosition>(contained.right, this.right, this.partitioner));
        }
        return difference;
    }

    public Set<Range<T>> subtract(Range<T> rhs) {
        return rhs.differenceToFetch(this);
    }

    public Set<Range<T>> differenceToFetch(Range<T> rhs) {
        HashSet<Range<T>> result;
        Set<Range<Range>> intersectionSet = this.intersectionWith(rhs);
        if (intersectionSet.isEmpty()) {
            result = new HashSet<Range<T>>();
            result.add(rhs);
        } else {
            Range[] intersections = new Range[intersectionSet.size()];
            intersectionSet.toArray(intersections);
            if (intersections.length == 1) {
                result = new HashSet<Range<T>>(super.subtractContained(intersections[0]));
            } else {
                Range first = intersections[0];
                Range second = intersections[1];
                ArrayList<Range<T>> temp = super.subtractContained(first);
                Range<T> single = temp.get(0);
                result = new HashSet<Range<T>>(super.subtractContained(second));
            }
        }
        return result;
    }

    public static <T extends RingPosition> boolean isInRanges(T token, Iterable<Range<T>> ranges) {
        assert (ranges != null);
        for (Range<T> range : ranges) {
            if (!range.contains(token)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Range)) {
            return false;
        }
        Range rhs = (Range)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "(" + this.left + "," + this.right + "]";
    }

    public List<String> asList() {
        ArrayList<String> ret = new ArrayList<String>(2);
        ret.add(this.left.toString());
        ret.add(this.right.toString());
        return ret;
    }

    public boolean isWrapAround() {
        return Range.isWrapAround(this.left, this.right);
    }

    public static <T extends RingPosition> List<Range<T>> normalize(Collection<Range<T>> ranges) {
        ArrayList<Range<T>> output = new ArrayList<Range<T>>();
        for (Range<T> range : ranges) {
            output.addAll(range.unwrap());
        }
        Collections.sort(output, new Comparator<Range<T>>(){

            @Override
            public int compare(Range<T> b1, Range<T> b2) {
                return b1.left.compareTo(b2.left);
            }
        });
        return Range.deoverlap(output);
    }

    private static <T extends RingPosition> List<Range<T>> deoverlap(List<Range<T>> ranges) {
        if (ranges.isEmpty()) {
            return ranges;
        }
        ArrayList<Range<T>> output = new ArrayList<Range<T>>();
        Iterator<Range<T>> iter = ranges.iterator();
        Range<Object> current = iter.next();
        Object min = current.partitioner.minValue(current.left.getClass());
        while (iter.hasNext()) {
            if (current.right.equals(min)) {
                if (current.left.equals(min)) {
                    return Collections.singletonList(current);
                }
                output.add(new Range<RingPosition>(current.left, (RingPosition)min));
                return output;
            }
            Range<T> next = iter.next();
            if (next.left.compareTo(current.right) <= 0) {
                if (!next.right.equals(min) && current.right.compareTo(next.right) >= 0) continue;
                current = new Range<RingPosition>(current.left, next.right);
                continue;
            }
            output.add(current);
            current = next;
        }
        output.add(current);
        return output;
    }

    public static Range<RowPosition> makeRowRange(Token left, Token right, IPartitioner partitioner) {
        return new Range<RowPosition>(left.maxKeyBound(partitioner), right.maxKeyBound(partitioner), partitioner);
    }

    @Override
    public AbstractBounds<RowPosition> toRowBounds() {
        return this.left instanceof Token ? Range.makeRowRange((Token)this.left, (Token)this.right, this.partitioner) : this;
    }

    @Override
    public AbstractBounds<Token> toTokenBounds() {
        return this.left instanceof RowPosition ? new Range<Token>(((RowPosition)this.left).getToken(), ((RowPosition)this.right).getToken(), this.partitioner) : this;
    }
}

