/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import org.apache.cassandra.net.CallbackInfo;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.IMessageCallback;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseVerbHandler
implements IVerbHandler {
    private static final Logger logger_ = LoggerFactory.getLogger(ResponseVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        double age = System.currentTimeMillis() - MessagingService.instance().getRegisteredCallbackAge(id);
        CallbackInfo callbackInfo = MessagingService.instance().removeRegisteredCallback(id);
        if (callbackInfo == null) {
            logger_.debug("Callback already removed for {}", (Object)id);
            return;
        }
        IMessageCallback cb = callbackInfo.callback;
        MessagingService.instance().maybeAddLatency(cb, message.getFrom(), age);
        if (cb instanceof IAsyncCallback) {
            if (logger_.isDebugEnabled()) {
                logger_.debug("Processing response on a callback from " + id + "@" + message.getFrom());
            }
            ((IAsyncCallback)cb).response(message);
        } else {
            if (logger_.isDebugEnabled()) {
                logger_.debug("Processing response on an async result from " + id + "@" + message.getFrom());
            }
            ((IAsyncResult)cb).result(message);
        }
    }
}

