/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

public class BigFloatArray {
    private static final long serialVersionUID = 1L;
    private float[][] _array;
    private int _numrows;
    private static final int BLOCK_SIZE = 1024;
    private static final int SHIFT_SIZE = 10;
    private static final int MASK = 1023;

    public BigFloatArray(int size) {
        this._numrows = size >> 10;
        this._array = new float[this._numrows + 1][];
        for (int i = 0; i <= this._numrows; ++i) {
            this._array[i] = new float[1024];
        }
    }

    public void add(int docId, float val) {
        this._array[docId >> 10][docId & 0x3FF] = val;
    }

    public float get(int docId) {
        return this._array[docId >> 10][docId & 0x3FF];
    }

    public int capacity() {
        return this._numrows * 1024;
    }

    public void ensureCapacity(int size) {
        int newNumrows = (size >> 10) + 1;
        if (newNumrows > this._array.length) {
            float[][] newArray = new float[newNumrows][];
            System.arraycopy(this._array, 0, newArray, 0, this._array.length);
            for (int i = this._array.length; i < newNumrows; ++i) {
                newArray[i] = new float[1024];
            }
            this._array = newArray;
        }
        this._numrows = newNumrows;
    }
}

