/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.googleapps;

import com.liferay.portal.googleapps.GAuthenticator;
import com.liferay.portal.googleapps.GBaseManagerImpl;
import com.liferay.portal.googleapps.GoogleApps;
import com.liferay.portal.kernel.googleapps.GEmailSettingsManager;
import com.liferay.portal.kernel.googleapps.GoogleAppsException;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;

public class GEmailSettingsManagerImpl
extends GBaseManagerImpl
implements GEmailSettingsManager {
    protected String emailSettingsURL;

    public GEmailSettingsManagerImpl(GoogleApps googleApps) {
        super(googleApps);
        GAuthenticator gAuthenticator = googleApps.getGAuthenticator();
        this.emailSettingsURL = "https://apps-apis.google.com/a/feeds".concat("/emailsettings/2.0/").concat(gAuthenticator.getDomain());
    }

    public void addSendAs(long userId, String fullName, String emailAddress) throws GoogleAppsException {
        Document document = SAXReaderUtil.createDocument();
        Element atomEntryElement = this.addAtomEntry(document);
        this.addAppsProperty(atomEntryElement, "name", fullName);
        this.addAppsProperty(atomEntryElement, "address", emailAddress);
        this.addAppsProperty(atomEntryElement, "makeDefault", Boolean.TRUE.toString());
        this.submitAdd(this.getEmailSettingsURL(userId).concat("/sendas"), document);
    }

    protected String getEmailSettingsURL(long userId) {
        return this.emailSettingsURL.concat("/").concat(String.valueOf(userId));
    }
}

