/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.ElementHandler;
import com.liferay.portal.kernel.xml.ElementProcessor;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.LayoutImporter;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DeletionSystemEventImporter {
    private static Log _log = LogFactoryUtil.getLog(DeletionSystemEventImporter.class);

    public void importDeletionSystemEvents(final PortletDataContext portletDataContext) throws Exception {
        if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"DELETIONS")) {
            return;
        }
        this.initDeletionSystemEventStagedModelTypes(portletDataContext);
        String xml = portletDataContext.getZipEntryAsString(String.valueOf(ExportImportPathUtil.getSourceRootPath((PortletDataContext)portletDataContext)) + "/deletion-system-events.xml");
        if (xml == null) {
            return;
        }
        XMLReader xmlReader = SecureXMLFactoryProviderUtil.newXMLReader();
        ElementHandler elementHandler = new ElementHandler(new ElementProcessor(){

            public void processElement(Element element) {
                DeletionSystemEventImporter.this.doImportDeletionSystemEvents(portletDataContext, element);
            }
        }, new String[]{"deletion-system-event"});
        xmlReader.setContentHandler((ContentHandler)elementHandler);
        xmlReader.parse(new InputSource(new StringReader(xml)));
    }

    protected void initDeletionSystemEventStagedModelTypes(PortletDataContext portletDataContext) {
        Element importDataRootElement = portletDataContext.getImportDataRootElement();
        if (importDataRootElement == null) {
            return;
        }
        Element portletsElement = importDataRootElement.element("portlets");
        ArrayList<Element> portletElements = Collections.emptyList();
        if (portletsElement != null) {
            portletElements = portletsElement.elements("portlet");
        } else {
            Element element = importDataRootElement.element("portlet");
            portletElements = new ArrayList<Element>();
            portletElements.add(element);
        }
        for (Element portletElement : portletElements) {
            PortletDataHandler portletDataHandler;
            String portletPath = portletElement.attributeValue("path");
            Document portletDocument = null;
            try {
                portletDocument = SAXReaderUtil.read((String)portletDataContext.getZipEntryAsString(portletPath));
            }
            catch (DocumentException documentException) {
                continue;
            }
            portletElement = portletDocument.getRootElement();
            if (portletElement == null) continue;
            Element portletDataElement = portletElement.element("portlet-data");
            String portletId = portletElement.attributeValue("portlet-id");
            Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
            if (!portlet.isActive() || (portletDataHandler = portlet.getPortletDataHandlerInstance()) == null) continue;
            Map<Object, Object> importPortletControlsMap = Collections.emptyMap();
            try {
                importPortletControlsMap = LayoutImporter.getImportPortletControlsMap(portletDataContext.getCompanyId(), portletId, portletDataContext.getParameterMap(), portletDataElement, portletDataContext.getManifestSummary());
            }
            catch (Exception exception) {}
            if (!((Boolean)importPortletControlsMap.get("PORTLET_DATA")).booleanValue()) continue;
            portletDataContext.addDeletionSystemEventStagedModelTypes(portletDataHandler.getDeletionSystemEventStagedModelTypes());
        }
    }

    protected void doImportDeletionSystemEvents(PortletDataContext portletDataContext, Element element) {
        block3: {
            StagedModelType stagedModelType;
            Set stagedModelTypes = portletDataContext.getDeletionSystemEventStagedModelTypes();
            if (!stagedModelTypes.contains(stagedModelType = new StagedModelType(element.attributeValue("class-name"), element.attributeValue("referrer-class-name")))) {
                return;
            }
            try {
                StagedModelDataHandlerUtil.deleteStagedModel((PortletDataContext)portletDataContext, (Element)element);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                StringBundler sb = new StringBundler(4);
                sb.append("Unable to process deletion for ");
                sb.append((Object)stagedModelType);
                sb.append(" with UUID ");
                sb.append(element.attributeValue("uuid"));
                _log.warn((Object)sb.toString());
            }
        }
    }
}

