/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.poller.PollerRequestResponsePair;
import java.util.HashMap;
import java.util.Map;

public class PollerSession {
    private Map<String, String> _pendingResponseIds = new HashMap<String, String>();
    private Map<String, PollerRequestResponsePair> _pollerRequestResponsePairs = new HashMap<String, PollerRequestResponsePair>();
    private String _pollerSessionId;

    public PollerSession(String pollerSessionId) {
        this._pollerSessionId = pollerSessionId;
    }

    public synchronized boolean beginPortletProcessing(PollerRequestResponsePair pollerRequestResponsePair, String responseId) {
        PollerRequest pollerRequest = pollerRequestResponsePair.getPollerRequest();
        String portletId = pollerRequest.getPortletId();
        if (this._pendingResponseIds.containsKey(portletId)) {
            return false;
        }
        this._pendingResponseIds.put(portletId, responseId);
        this._pollerRequestResponsePairs.put(portletId, pollerRequestResponsePair);
        return true;
    }

    public synchronized boolean completePortletProcessing(String portletId, String responseId) {
        String pendingResponseId = this._pendingResponseIds.get(portletId);
        if (responseId.equals(pendingResponseId)) {
            this._pendingResponseIds.remove(portletId);
            this._pollerRequestResponsePairs.remove(portletId);
        }
        return this._pendingResponseIds.isEmpty();
    }

    public String getPollerSessionId() {
        return this._pollerSessionId;
    }
}

