/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.NoSuchFolderException;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalPermission;

public class JournalFolderPermission {
    public static void check(PermissionChecker permissionChecker, JournalFolder folder, String actionId) throws PortalException, SystemException {
        if (!JournalFolderPermission.contains(permissionChecker, folder, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (!JournalFolderPermission.contains(permissionChecker, groupId, folderId, actionId)) {
            throw new PrincipalException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contains(PermissionChecker permissionChecker, JournalFolder folder, String actionId) throws PortalException, SystemException {
        Boolean hasPermission;
        if (actionId.equals("ADD_FOLDER")) {
            actionId = "ADD_SUBFOLDER";
        }
        if ((hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)folder.getGroupId(), (String)JournalFolder.class.getName(), (long)folder.getFolderId(), (String)"15", (String)actionId)) != null) {
            return hasPermission;
        }
        if (!actionId.equals("VIEW")) return JournalFolderPermission._hasPermission(permissionChecker, folder, actionId);
        if (!PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) return JournalFolderPermission._hasPermission(permissionChecker, folder, actionId);
        try {
            long folderId = folder.getFolderId();
            while (true) {
                if (folderId == 0L) {
                    return JournalPermission.contains(permissionChecker, folder.getGroupId(), actionId);
                }
                folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
                if (!JournalFolderPermission._hasPermission(permissionChecker, folder, actionId)) {
                    return false;
                }
                folderId = folder.getParentFolderId();
            }
        }
        catch (NoSuchFolderException nsfe) {
            if (folder.isInTrash()) return JournalPermission.contains(permissionChecker, folder.getGroupId(), actionId);
            throw nsfe;
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (folderId == 0L) {
            return JournalPermission.contains(permissionChecker, groupId, actionId);
        }
        JournalFolder folder = JournalFolderLocalServiceUtil.getJournalFolder((long)folderId);
        return JournalFolderPermission.contains(permissionChecker, folder, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, JournalFolder folder, String actionId) {
        return permissionChecker.hasOwnerPermission(folder.getCompanyId(), JournalFolder.class.getName(), folder.getFolderId(), folder.getUserId(), actionId) || permissionChecker.hasPermission(folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), actionId);
    }
}

