/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.service.base.MBDiscussionLocalServiceBaseImpl;
import java.util.Date;

public class MBDiscussionLocalServiceImpl
extends MBDiscussionLocalServiceBaseImpl {
    public MBDiscussion addDiscussion(long userId, long classNameId, long classPK, long threadId, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date now = new Date();
        long discussionId = this.counterLocalService.increment();
        MBDiscussion discussion = this.mbDiscussionPersistence.create(discussionId);
        discussion.setUuid(serviceContext.getUuid());
        discussion.setGroupId(groupId);
        discussion.setCompanyId(serviceContext.getCompanyId());
        discussion.setUserId(userId);
        discussion.setUserName(user.getFullName());
        discussion.setCreateDate(serviceContext.getCreateDate(now));
        discussion.setModifiedDate(serviceContext.getModifiedDate(now));
        discussion.setClassNameId(classNameId);
        discussion.setClassPK(classPK);
        discussion.setThreadId(threadId);
        this.mbDiscussionPersistence.update((BaseModel)discussion);
        return discussion;
    }

    public MBDiscussion fetchDiscussion(long discussionId) throws SystemException {
        return this.mbDiscussionPersistence.fetchByPrimaryKey(discussionId);
    }

    public MBDiscussion fetchDiscussion(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK);
    }

    public MBDiscussion getDiscussion(long discussionId) throws PortalException, SystemException {
        return this.mbDiscussionPersistence.findByPrimaryKey(discussionId);
    }

    public MBDiscussion getDiscussion(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mbDiscussionPersistence.findByC_C(classNameId, classPK);
    }

    public MBDiscussion getThreadDiscussion(long threadId) throws PortalException, SystemException {
        return this.mbDiscussionPersistence.findByThreadId(threadId);
    }
}

