/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.social.model.SocialAchievement;
import com.liferay.portlet.social.model.SocialActivityAchievement;
import com.liferay.portlet.social.service.base.SocialActivityAchievementLocalServiceBaseImpl;
import java.util.List;

public class SocialActivityAchievementLocalServiceImpl
extends SocialActivityAchievementLocalServiceBaseImpl {
    public void addActivityAchievement(long userId, long groupId, SocialAchievement achievement) throws PortalException, SystemException {
        SocialActivityAchievement activityAchievement = this.socialActivityAchievementPersistence.fetchByG_U_N(groupId, userId, achievement.getName());
        if (activityAchievement != null) {
            return;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        long activityAchievementId = this.counterLocalService.increment();
        activityAchievement = this.socialActivityAchievementPersistence.create(activityAchievementId);
        activityAchievement.setGroupId(groupId);
        activityAchievement.setCompanyId(user.getCompanyId());
        activityAchievement.setUserId(userId);
        activityAchievement.setCreateDate(System.currentTimeMillis());
        int count = this.socialActivityAchievementPersistence.countByG_N(groupId, achievement.getName());
        if (count == 0) {
            activityAchievement.setFirstInGroup(true);
        }
        activityAchievement.setName(achievement.getName());
        this.socialActivityAchievementPersistence.update((BaseModel)activityAchievement);
        this.socialActivityCounterLocalService.incrementUserAchievementCounter(userId, groupId);
    }

    public SocialActivityAchievement fetchUserAchievement(long userId, long groupId, String name) throws SystemException {
        return this.socialActivityAchievementPersistence.fetchByG_U_N(groupId, userId, name);
    }

    public List<SocialActivityAchievement> getGroupAchievements(long groupId) throws SystemException {
        return this.socialActivityAchievementPersistence.findByGroupId(groupId);
    }

    public List<SocialActivityAchievement> getGroupAchievements(long groupId, String name) throws SystemException {
        return this.socialActivityAchievementPersistence.findByG_N(groupId, name);
    }

    public int getGroupAchievementsCount(long groupId) throws SystemException {
        return this.socialActivityAchievementPersistence.countByGroupId(groupId);
    }

    public int getGroupAchievementsCount(long groupId, String name) throws SystemException {
        return this.socialActivityAchievementPersistence.countByG_N(groupId, name);
    }

    public List<SocialActivityAchievement> getGroupFirstAchievements(long groupId) throws SystemException {
        return this.socialActivityAchievementPersistence.findByG_F(groupId, true);
    }

    public int getGroupFirstAchievementsCount(long groupId) throws SystemException {
        return this.socialActivityAchievementPersistence.countByG_F(groupId, true);
    }

    public List<SocialActivityAchievement> getUserAchievements(long userId, long groupId) throws SystemException {
        return this.socialActivityAchievementPersistence.findByG_U(groupId, userId);
    }

    public int getUserAchievementsCount(long userId, long groupId) throws SystemException {
        return this.socialActivityAchievementPersistence.countByG_U(groupId, userId);
    }
}

