/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.trash.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashEntryList;
import com.liferay.portlet.trash.service.TrashEntryServiceUtil;

public class TrashEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(TrashEntryServiceHttp.class);
    private static final Class<?>[] _deleteEntriesParameterTypes0 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteEntriesParameterTypes1 = new Class[]{long[].class};
    private static final Class<?>[] _deleteEntryParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _deleteEntryParameterTypes3 = new Class[]{String.class, Long.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getEntriesParameterTypes5 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _moveEntryParameterTypes6 = new Class[]{String.class, Long.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _restoreEntryParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreEntryParameterTypes8 = new Class[]{Long.TYPE, Long.TYPE, String.class};

    public static void deleteEntries(HttpPrincipal httpPrincipal, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "deleteEntries", (Class[])_deleteEntriesParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteEntries(HttpPrincipal httpPrincipal, long[] entryIds) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "deleteEntries", (Class[])_deleteEntriesParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryIds});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "deleteEntry", (Class[])_deleteEntryParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteEntry(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "deleteEntry", (Class[])_deleteEntryParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static TrashEntryList getEntries(HttpPrincipal httpPrincipal, long groupId) throws SystemException, PrincipalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                if (e2 instanceof PrincipalException) {
                    throw (PrincipalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (TrashEntryList)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static TrashEntryList getEntries(HttpPrincipal httpPrincipal, long groupId, int start, int end, OrderByComparator obc) throws SystemException, PrincipalException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "getEntries", (Class[])_getEntriesParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, start, end, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                if (e2 instanceof PrincipalException) {
                    throw (PrincipalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (TrashEntryList)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void moveEntry(HttpPrincipal httpPrincipal, String className, long classPK, long destinationContainerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "moveEntry", (Class[])_moveEntryParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK, destinationContainerModelId, serviceContext});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static TrashEntry restoreEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "restoreEntry", (Class[])_restoreEntryParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (TrashEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static TrashEntry restoreEntry(HttpPrincipal httpPrincipal, long entryId, long overrideClassPK, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(TrashEntryServiceUtil.class, "restoreEntry", (Class[])_restoreEntryParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId, overrideClassPK, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (TrashEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

