/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.servlet.taglib.aui.ValidatorTag;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.taglib.aui.InputTag;
import com.liferay.taglib.aui.base.BaseValidatorTagImpl;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

public class ValidatorTagImpl
extends BaseValidatorTagImpl
implements BodyTag,
ValidatorTag {
    private String _body;
    private boolean _custom;
    private boolean _customValidatorRequired = true;

    public ValidatorTagImpl() {
    }

    public ValidatorTagImpl(String name, String errorMessage, String body, boolean custom) {
        this(name, errorMessage, body, custom, true);
    }

    public ValidatorTagImpl(String name, String errorMessage, String body, boolean custom, boolean customValidatorRequired) {
        this.setName(name);
        this.setErrorMessage(errorMessage);
        this._body = body;
        this._custom = custom;
        this._customValidatorRequired = customValidatorRequired;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this._body = null;
        this._custom = false;
        this._customValidatorRequired = true;
    }

    public int doAfterBody() {
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent != null) {
            this._body = bodyContent.getString();
        }
        return 0;
    }

    public int doEndTag() {
        InputTag inputTag = (InputTag)ValidatorTagImpl.findAncestorWithClass((Tag)this, InputTag.class);
        String name = this.getName();
        this._custom = ModelHintsUtil.isCustomValidator((String)name);
        if (this._custom) {
            name = ModelHintsUtil.buildCustomValidatorName((String)name);
        }
        ValidatorTagImpl validatorTag = new ValidatorTagImpl(name, this.getErrorMessage(), this._body, this._custom, this._customValidatorRequired);
        inputTag.addValidatorTag(name, validatorTag);
        return 2;
    }

    public String getBody() {
        if (Validator.isNull((String)this._body)) {
            return "''";
        }
        return this._body.trim();
    }

    @Override
    public String getErrorMessage() {
        String errorMessage = super.getErrorMessage();
        if (errorMessage == null) {
            return "";
        }
        return errorMessage;
    }

    public boolean isCustom() {
        return this._custom;
    }

    public boolean isCustomValidatorRequired() {
        return this._customValidatorRequired;
    }

    @Override
    public void setCustomValidatorRequired(boolean customValidatorRequired) {
        this._customValidatorRequired = customValidatorRequired;
    }

    public void setBody(String body) {
        this._body = body;
    }

    protected String processCustom(String name) {
        if (name.equals("custom")) {
            this._custom = true;
            return name.concat("_").concat(StringUtil.randomId());
        }
        return name;
    }
}

