/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PointIteratorMultidim
implements PointFeatureIterator {
    private static Logger log = LoggerFactory.getLogger(PointIteratorMultidim.class);
    private List<Variable> vars;
    private StructureMembers members;
    private int outerIndex;
    private PointFeatureIterator.Filter filter;
    private int count;
    private int npts;
    private PointFeature feature;

    protected abstract PointFeature makeFeature(int var1, StructureData var2) throws IOException;

    public PointIteratorMultidim(String name, List<Variable> vars, int outerIndex, PointFeatureIterator.Filter filter) {
        this.vars = vars;
        this.outerIndex = outerIndex;
        this.filter = filter;
        Variable v = vars.get(0);
        this.npts = v.getDimension(1).getLength();
        this.members = new StructureMembers(name);
        for (Variable var : vars) {
            int[] shape = var.getShape();
            int[] newShape = new int[shape.length - 2];
            System.arraycopy(shape, 2, newShape, 0, shape.length - 2);
            this.members.addMember(var.getShortName(), var.getDescription(), var.getUnitsString(), var.getDataType(), newShape);
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        while (this.count < this.npts) {
            StructureData sdata = this.nextStructureData();
            this.feature = this.makeFeature(this.count, sdata);
            ++this.count;
            if (this.filter != null && !this.filter.filter(this.feature)) continue;
            return true;
        }
        this.feature = null;
        return false;
    }

    @Override
    public PointFeature next() throws IOException {
        return this.feature;
    }

    private StructureData nextStructureData() throws IOException {
        StructureDataW sdata = new StructureDataW(this.members);
        for (Variable var : this.vars) {
            Section s = new Section();
            try {
                s.appendRange(this.outerIndex, this.outerIndex);
                s.appendRange(this.count, this.count);
                for (int i = 2; i < var.getRank(); ++i) {
                    s.appendRange(null);
                }
                Array data = var.read(s);
                sdata.setMemberData(var.getShortName(), data);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
        return sdata;
    }

    @Override
    public void setBufferSize(int bytes) {
    }
}

