/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.proxies;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.gcube.data.tml.Utils;
import org.gcube.data.tml.stubs.Types;
import org.w3c.dom.Element;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"broadcast", "plugin", "payload"})
public class BindRequest {
    private String plugin;
    private boolean broadcast;
    private Types.AnyWrapper payload = new Types.AnyWrapper();

    BindRequest() {
    }

    public BindRequest(String plugin) {
        this.setPlugin(plugin);
    }

    public BindRequest(String plugin, Element payload) {
        this(plugin);
        this.setPayload(payload);
    }

    public BindRequest(String plugin, Element payload, boolean broadcast) {
        this(plugin, payload);
        this.setBroadcast(broadcast);
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String name) throws IllegalArgumentException {
        Utils.notNull("plugin", name);
        this.plugin = name;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public Element getPayload() {
        return this.payload.element;
    }

    public void setPayload(Element payload) {
        Utils.notNull("payload", payload);
        this.payload = new Types.AnyWrapper(payload);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.broadcast ? 1231 : 1237);
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.plugin == null ? 0 : this.plugin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BindRequest other = (BindRequest)obj;
        if (this.broadcast != other.broadcast) {
            return false;
        }
        if (this.payload == null ? other.payload != null : !this.payload.equals(other.payload)) {
            return false;
        }
        return !(this.plugin == null ? other.plugin != null : !this.plugin.equals(other.plugin));
    }

    public String toString() {
        return "BindParams [plugin=" + this.plugin + ", broadcast=" + this.broadcast + ", payload=" + this.payload + "]";
    }
}

