/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.servlet;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class PACLRequestDispatcherWrapper
implements RequestDispatcher {
    private RequestDispatcher _requestDispatcher;
    private ServletContext _servletContext;

    public PACLRequestDispatcherWrapper(ServletContext servletContext, RequestDispatcher requestDispatcher) {
        this._servletContext = servletContext;
        this._requestDispatcher = requestDispatcher;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.doDispatch(servletRequest, servletResponse, false);
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.doDispatch(servletRequest, servletResponse, true);
    }

    protected void doDispatch(ServletRequest servletRequest, ServletResponse servletResponse, boolean include) throws IOException, ServletException {
        ClassLoader pluginClassLoader = (ClassLoader)this._servletContext.getAttribute("PLUGIN_CLASS_LOADER");
        DispatchPrivilegedExceptionAction dispatchPrivilegedExceptionAction = new DispatchPrivilegedExceptionAction(this._requestDispatcher, servletRequest, servletResponse, include);
        try {
            if (pluginClassLoader == null) {
                AccessController.doPrivileged(dispatchPrivilegedExceptionAction);
            } else {
                dispatchPrivilegedExceptionAction.run();
            }
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (ServletException)pae.getException();
        }
    }

    private class DispatchPrivilegedExceptionAction
    implements PrivilegedExceptionAction<Void> {
        private boolean _include;
        private RequestDispatcher _requestDispatcher;
        private ServletRequest _servletRequest;
        private ServletResponse _servletResponse;

        public DispatchPrivilegedExceptionAction(RequestDispatcher requestDispatcher, ServletRequest servletRequest, ServletResponse servletResponse, boolean include) {
            this._requestDispatcher = requestDispatcher;
            this._servletRequest = servletRequest;
            this._servletResponse = servletResponse;
            this._include = include;
        }

        @Override
        public Void run() throws IOException, ServletException {
            if (this._include) {
                this._requestDispatcher.include(this._servletRequest, this._servletResponse);
            } else {
                this._requestDispatcher.forward(this._servletRequest, this._servletResponse);
            }
            return null;
        }
    }
}

