/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.SortedSet;
import javax.annotation.processing.Messager;
import lombok.javac.HandlerLibrary;
import lombok.javac.JavacAST;
import lombok.javac.JavacASTAdapter;
import lombok.javac.JavacNode;
import lombok.javac.LombokOptions;

public class JavacTransformer {
    private final HandlerLibrary handlers;
    private final Messager messager;

    public JavacTransformer(Messager messager) {
        this.messager = messager;
        this.handlers = HandlerLibrary.load(messager);
    }

    public SortedSet<Long> getPriorities() {
        return this.handlers.getPriorities();
    }

    public SortedSet<Long> getPrioritiesRequiringResolutionReset() {
        return this.handlers.getPrioritiesRequiringResolutionReset();
    }

    public void transform(long priority, Context context, java.util.List<JCTree.JCCompilationUnit> compilationUnitsRaw) {
        List<JCTree.JCCompilationUnit> compilationUnits;
        if (compilationUnitsRaw instanceof List) {
            compilationUnits = (List<JCTree.JCCompilationUnit>)compilationUnitsRaw;
        } else {
            compilationUnits = List.nil();
            for (int i = compilationUnitsRaw.size() - 1; i >= 0; --i) {
                compilationUnits = compilationUnits.prepend(compilationUnitsRaw.get(i));
            }
        }
        ArrayList<JavacAST> asts = new ArrayList<JavacAST>();
        for (JCTree.JCCompilationUnit unit : compilationUnits) {
            asts.add(new JavacAST(this.messager, context, unit));
        }
        for (JavacAST ast : asts) {
            ast.traverse(new AnnotationVisitor(priority));
            this.handlers.callASTVisitors(ast, priority);
        }
        for (JavacAST ast : asts) {
            if (!ast.isChanged()) continue;
            LombokOptions.markChanged(context, (JCTree.JCCompilationUnit)((JavacNode)ast.top()).get());
        }
    }

    private class AnnotationVisitor
    extends JavacASTAdapter {
        private final long priority;

        AnnotationVisitor(long priority) {
            this.priority = priority;
        }

        @Override
        public void visitAnnotationOnType(JCTree.JCClassDecl type, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation, this.priority);
        }

        @Override
        public void visitAnnotationOnField(JCTree.JCVariableDecl field, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation, this.priority);
        }

        @Override
        public void visitAnnotationOnMethod(JCTree.JCMethodDecl method, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation, this.priority);
        }

        @Override
        public void visitAnnotationOnMethodArgument(JCTree.JCVariableDecl argument, JCTree.JCMethodDecl method, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation, this.priority);
        }

        @Override
        public void visitAnnotationOnLocal(JCTree.JCVariableDecl local, JavacNode annotationNode, JCTree.JCAnnotation annotation) {
            JCTree.JCCompilationUnit top = (JCTree.JCCompilationUnit)((JavacNode)annotationNode.top()).get();
            JavacTransformer.this.handlers.handleAnnotation(top, annotationNode, annotation, this.priority);
        }
    }
}

