/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class SearchResultUtil {
    private static Log _log = LogFactoryUtil.getLog(SearchResultUtil.class);

    public static List<SearchResult> getSearchResults(Hits hits, Locale locale, PortletURL portletURL) {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        Document[] documentArray = hits.getDocs();
        int n = documentArray.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                Document document = documentArray[n2];
                String entryClassName = GetterUtil.getString(document.get("entryClassName"));
                long entryClassPK = GetterUtil.getLong(document.get("entryClassPK"));
                try {
                    Summary summary;
                    SearchResult searchResult;
                    int index;
                    String className = entryClassName;
                    long classPK = entryClassPK;
                    FileEntry fileEntry = null;
                    MBMessage mbMessage = null;
                    if (entryClassName.equals(DLFileEntry.class.getName()) || entryClassName.equals(MBMessage.class.getName())) {
                        classPK = GetterUtil.getLong(document.get("classPK"));
                        long classNameId = GetterUtil.getLong(document.get("classNameId"));
                        if (classPK > 0L && classNameId > 0L) {
                            className = PortalUtil.getClassName(classNameId);
                            if (entryClassName.equals(DLFileEntry.class.getName())) {
                                fileEntry = DLAppLocalServiceUtil.getFileEntry(entryClassPK);
                            } else if (entryClassName.equals(MBMessage.class.getName())) {
                                mbMessage = MBMessageLocalServiceUtil.getMessage(entryClassPK);
                            }
                        } else {
                            className = entryClassName;
                            classPK = entryClassPK;
                        }
                    }
                    if ((index = searchResults.indexOf(searchResult = new SearchResult(className, classPK))) < 0) {
                        searchResults.add(searchResult);
                    } else {
                        searchResult = (SearchResult)searchResults.get(index);
                    }
                    if (fileEntry != null) {
                        summary = SearchResultUtil.getSummary(document, DLFileEntry.class.getName(), fileEntry.getFileEntryId(), locale, portletURL);
                        searchResult.addFileEntry(fileEntry, summary);
                    }
                    if (mbMessage != null) {
                        searchResult.addMBMessage(mbMessage);
                    }
                    if (entryClassName.equals(JournalArticle.class.getName())) {
                        String version = document.get("version");
                        searchResult.addVersion(version);
                    }
                    if (mbMessage == null && fileEntry == null) {
                        summary = SearchResultUtil.getSummary(document, className, classPK, locale, portletURL);
                        searchResult.setSummary(summary);
                    } else if (searchResult.getSummary() == null) {
                        summary = SearchResultUtil.getSummary(className, classPK, locale, portletURL);
                        searchResult.setSummary(summary);
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block17;
                    _log.warn("Search index is stale and contains entry {" + entryClassPK + "}");
                }
            }
            ++n2;
        }
        return searchResults;
    }

    protected static Summary getSummary(Document document, String className, long classPK, Locale locale, PortletURL portletURL) throws PortalException, SystemException {
        Indexer indexer = IndexerRegistryUtil.getIndexer(className);
        if (indexer != null) {
            String snippet = document.get("snippet");
            return indexer.getSummary(document, locale, snippet, portletURL);
        }
        return SearchResultUtil.getSummary(className, classPK, locale, portletURL);
    }

    protected static Summary getSummary(String className, long classPK, Locale locale, PortletURL portletURL) throws PortalException, SystemException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(className);
        if (assetRendererFactory == null) {
            return null;
        }
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
        if (assetRenderer == null) {
            return null;
        }
        Summary summary = new Summary(assetRenderer.getTitle(locale), assetRenderer.getSearchSummary(locale), portletURL);
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        return summary;
    }
}

