/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.HsqlList;

public class HsqlArrayList
extends BaseList
implements HsqlList {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    Object[] elementData;
    Object[] reserveElementData;
    private boolean minimizeOnClear;

    public HsqlArrayList(Object[] data, int count) {
        this.elementData = data;
        this.elementCount = count;
    }

    public HsqlArrayList() {
        this.elementData = new Object[10];
    }

    public HsqlArrayList(boolean minimize) {
        this.elementData = new Object[10];
        this.minimizeOnClear = minimize;
    }

    public HsqlArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        this.elementData = initialCapacity == 0 ? new Object[1] : new Object[initialCapacity];
    }

    public void add(int index, Object element) {
        if (index > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + ">" + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        for (int i = this.elementCount; i > index; --i) {
            this.elementData[i] = this.elementData[i - 1];
        }
        this.elementData[index] = element;
        ++this.elementCount;
    }

    public boolean add(Object element) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = element;
        ++this.elementCount;
        return true;
    }

    public Object get(int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        return this.elementData[index];
    }

    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (!o.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public Object remove(int index) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        Object removedObj = this.elementData[index];
        for (int i = index; i < this.elementCount - 1; ++i) {
            this.elementData[i] = this.elementData[i + 1];
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.clear();
        } else {
            this.elementData[this.elementCount] = null;
        }
        return removedObj;
    }

    public Object set(int index, Object element) {
        if (index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + " < 0");
        }
        Object replacedObj = this.elementData[index];
        this.elementData[index] = element;
        return replacedObj;
    }

    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        int baseSize = this.elementData.length == 0 ? 1 : this.elementData.length;
        baseSize = (int)((float)baseSize * 2.0f);
        this.resize(baseSize);
    }

    private void resize(int baseSize) {
        if (baseSize == this.elementData.length) {
            return;
        }
        Object[] newArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), baseSize);
        int count = this.elementData.length > newArray.length ? newArray.length : this.elementData.length;
        System.arraycopy(this.elementData, 0, newArray, 0, count);
        if (this.minimizeOnClear && this.reserveElementData == null) {
            ArrayUtil.clearArray(76, this.elementData, 0, this.elementData.length);
            this.reserveElementData = this.elementData;
        }
        this.elementData = newArray;
    }

    public void trim() {
        this.resize(this.elementCount);
    }

    public void clear() {
        if (this.minimizeOnClear && this.reserveElementData != null) {
            this.elementData = this.reserveElementData;
            this.reserveElementData = null;
            this.elementCount = 0;
            return;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public void setSize(int newSize) {
        if (newSize == 0) {
            this.clear();
            return;
        }
        if (newSize <= this.elementCount) {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
            this.elementCount = newSize;
            return;
        }
        while (newSize > this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementCount = newSize;
    }

    public Object[] toArray() {
        Object[] newArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), this.elementCount);
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementCount);
        return newArray;
    }

    public Object[] toArray(int start, int limit) {
        Object[] newArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), limit - start);
        System.arraycopy(this.elementData, start, newArray, 0, limit - start);
        return newArray;
    }

    public Object toArray(Object a) {
        if (Array.getLength(a) < this.elementCount) {
            a = Array.newInstance(a.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.elementCount);
        return a;
    }

    public void sort(Comparator c) {
        if (this.elementCount < 2) {
            return;
        }
        ArraySort.sort(this.elementData, 0, this.elementCount, c);
    }

    public Object[] getArray() {
        return this.elementData;
    }
}

