/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

public class BitMap {
    int defaultCapacity;
    int capacity;
    int[] map;
    int limitPos;

    public BitMap(int initialCapacity) {
        int words = initialCapacity / 32;
        if (initialCapacity % 32 != 0) {
            ++words;
        }
        this.defaultCapacity = this.capacity = words * 32;
        this.map = new int[words];
        this.limitPos = 0;
    }

    public int size() {
        return this.limitPos;
    }

    public void setSize(int size) {
        this.limitPos = size;
    }

    public void reset() {
        this.map = new int[this.defaultCapacity / 32];
        this.capacity = this.defaultCapacity;
        this.limitPos = 0;
    }

    public int set(int pos) {
        int mask;
        int windex;
        int word;
        while (pos >= this.capacity) {
            this.doubleCapacity();
        }
        if (pos >= this.limitPos) {
            this.limitPos = pos + 1;
        }
        int result = ((word = this.map[windex = pos >> 5]) & (mask = Integer.MIN_VALUE >>> (pos & 0x1F))) == 0 ? 0 : 1;
        this.map[windex] = word | mask;
        return result;
    }

    public int unset(int pos) {
        while (pos >= this.capacity) {
            this.doubleCapacity();
        }
        if (pos >= this.limitPos) {
            this.limitPos = pos + 1;
            return 0;
        }
        int windex = pos >> 5;
        int word = this.map[windex];
        int mask = Integer.MIN_VALUE >>> (pos & 0x1F);
        int result = (word & mask) == 0 ? 0 : 1;
        this.map[windex] = word & (mask ^= 0xFFFFFFFF);
        return result;
    }

    public int get(int pos) {
        while (pos >= this.capacity) {
            this.doubleCapacity();
        }
        if (pos >= this.limitPos) {
            this.limitPos = pos + 1;
            return 0;
        }
        int windex = pos >> 5;
        int word = this.map[windex];
        int mask = Integer.MIN_VALUE >>> (pos & 0x1F);
        return (word & mask) == 0 ? 0 : 1;
    }

    public boolean isSet(int pos) {
        return this.get(pos) == 1;
    }

    public byte[] getBytes() {
        byte[] buf = new byte[(this.limitPos + 7) / 8];
        if (buf.length == 0) {
            return buf;
        }
        int i = 0;
        do {
            int v = this.map[i / 4];
            buf[i++] = (byte)(v >>> 24);
            if (i == buf.length) break;
            buf[i++] = (byte)(v >>> 16);
            if (i == buf.length) break;
            buf[i++] = (byte)(v >>> 8);
            if (i == buf.length) break;
            buf[i++] = (byte)v;
        } while (i != buf.length);
        return buf;
    }

    private void doubleCapacity() {
        int[] newmap = new int[this.map.length * 2];
        this.capacity *= 2;
        System.arraycopy(this.map, 0, newmap, 0, this.map.length);
        this.map = newmap;
    }

    public static int setByte(int map, byte value, int pos) {
        int intValue = (value & 0xFF) << 24 - pos;
        int mask = -16777216 >>> pos;
        return (map &= (mask ^= 0xFFFFFFFF)) | intValue;
    }

    public static int set(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return map | mask;
    }

    public static byte set(byte map, int pos) {
        int mask = 128 >>> pos;
        return (byte)(map | mask);
    }

    public static int unset(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return map & (mask ^= 0xFFFFFFFF);
    }

    public static boolean isSet(int map, int pos) {
        int mask = Integer.MIN_VALUE >>> pos;
        return (map & mask) != 0;
    }

    public static boolean isSet(byte map, int pos) {
        int mask = 128 >>> pos;
        return (map & mask) != 0;
    }

    public static boolean isSet(byte[] map, int pos) {
        int mask = 128 >>> (pos & 7);
        int index = pos / 8;
        if (index >= map.length) {
            return false;
        }
        byte b = map[index];
        return (b & mask) != 0;
    }

    public static void unset(byte[] map, int pos) {
        int mask = 128 >>> (pos & 7);
        mask ^= 0xFFFFFFFF;
        int index = pos / 8;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        map[index] = (byte)(b & mask);
    }

    public static void set(byte[] map, int pos) {
        int mask = 128 >>> (pos & 7);
        int index = pos / 8;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        map[index] = (byte)(b | mask);
    }

    public static void and(byte[] map, int pos, byte source, int count) {
        int shift = pos & 7;
        int mask = (source & 0xFF) >>> shift;
        int innermask = 255 >> shift;
        int index = pos / 8;
        if (count < 8) {
            innermask >>>= 8 - count;
            innermask <<= 8 - count;
        }
        mask &= innermask;
        innermask ^= 0xFFFFFFFF;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        map[index] = (byte)(b & innermask);
        b = (byte)(b & mask);
        map[index] = (byte)(map[index] | b);
        if (shift == 0) {
            return;
        }
        if (count > (shift = 8 - shift)) {
            mask = (source & 0xFF) << 8 >>> shift;
            innermask = 65280 >>> shift;
            b = map[index + 1];
            map[index + 1] = (byte)(b & (innermask ^= 0xFFFFFFFF));
            b = (byte)(b & mask);
            map[index + 1] = (byte)(map[index + 1] | b);
        }
    }

    public static void or(byte[] map, int pos, byte source, int count) {
        byte b;
        int shift = pos & 7;
        int mask = (source & 0xFF) >>> shift;
        int index = pos / 8;
        if (index >= map.length) {
            return;
        }
        map[index] = b = (byte)(map[index] | mask);
        if (shift == 0) {
            return;
        }
        if (count > (shift = 8 - shift)) {
            mask = (source & 0xFF) << 8 >>> shift;
            map[index + 1] = b = (byte)(map[index + 1] | mask);
        }
    }

    public static void overlay(byte[] map, int pos, byte source, int count) {
        int shift = pos & 7;
        int mask = (source & 0xFF) >>> shift;
        int innermask = 255 >> shift;
        int index = pos / 8;
        if (count < 8) {
            innermask >>>= 8 - count;
            innermask <<= 8 - count;
        }
        mask &= innermask;
        innermask ^= 0xFFFFFFFF;
        if (index >= map.length) {
            return;
        }
        byte b = map[index];
        b = (byte)(b & innermask);
        map[index] = (byte)(b | mask);
        if (shift == 0) {
            return;
        }
        if (count > (shift = 8 - shift)) {
            mask = (source & 0xFF) << 8 >>> shift;
            innermask = 65280 >>> shift;
            b = map[index + 1];
            b = (byte)(b & (innermask ^= 0xFFFFFFFF));
            map[index + 1] = (byte)(b | mask);
        }
    }

    public static int compare(byte[] a, byte[] b) {
        int shortLength = a.length > b.length ? b.length : a.length;
        for (int i = 0; i < shortLength; ++i) {
            if (a[i] == b[i]) continue;
            return (a[i] & 0xFF) > (b[i] & 0xFF) ? 1 : -1;
        }
        if (a.length == b.length) {
            return 0;
        }
        return a.length > b.length ? 1 : -1;
    }

    public static byte[] and(byte[] a, byte[] b) {
        int length = a.length > b.length ? a.length : b.length;
        int shortLength = a.length > b.length ? b.length : a.length;
        byte[] map = new byte[length];
        for (int i = 0; i < shortLength; ++i) {
            map[i] = (byte)(a[i] & b[i]);
        }
        return map;
    }

    public static byte[] or(byte[] a, byte[] b) {
        int length = a.length > b.length ? a.length : b.length;
        int shortLength = a.length > b.length ? b.length : a.length;
        byte[] map = new byte[length];
        if (length != shortLength) {
            byte[] source = a.length > b.length ? a : b;
            System.arraycopy(source, shortLength, map, shortLength, length - shortLength);
        }
        for (int i = 0; i < shortLength; ++i) {
            map[i] = (byte)(a[i] | b[i]);
        }
        return map;
    }

    public static byte[] xor(byte[] a, byte[] b) {
        int length = a.length > b.length ? a.length : b.length;
        int shortLength = a.length > b.length ? b.length : a.length;
        byte[] map = new byte[length];
        if (length != shortLength) {
            byte[] source = a.length > b.length ? a : b;
            System.arraycopy(source, shortLength, map, shortLength, length - shortLength);
        }
        for (int i = 0; i < shortLength; ++i) {
            map[i] = (byte)(a[i] ^ b[i]);
        }
        return map;
    }

    public static byte[] not(byte[] a) {
        byte[] map = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            map[i] = ~a[i];
        }
        return map;
    }

    public static boolean hasAnyBitSet(byte[] map) {
        for (int i = 0; i < map.length; ++i) {
            if (map[i] == 0) continue;
            return true;
        }
        return false;
    }

    public static byte[] leftShift(byte[] map, int shiftBits) {
        byte[] newMap = new byte[map.length];
        int shiftBytes = shiftBits / 8;
        if (shiftBytes >= map.length) {
            return newMap;
        }
        if ((shiftBits %= 8) == 0) {
            int i = 0;
            for (int j = shiftBytes; j < map.length; ++j) {
                newMap[i] = map[j];
                ++i;
            }
        } else {
            int i = 0;
            for (int j = shiftBytes; j < map.length; ++j) {
                int shifted = (map[j] & 0xFF) << shiftBits;
                newMap[i] = (byte)shifted;
                if (i > 0) {
                    int n = i - 1;
                    newMap[n] = (byte)(newMap[n] | (byte)(shifted >>> 8));
                }
                ++i;
            }
        }
        return newMap;
    }
}

