/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.QueryStatement;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStatementImpl
implements QueryStatement {
    private final Session session;
    private final String statement;
    private final Map<Integer, String> parametersMap;

    public QueryStatementImpl(Session session, String statement) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        if (statement == null) {
            throw new IllegalArgumentException("Statement must be set!");
        }
        this.session = session;
        this.statement = statement.trim();
        this.parametersMap = new HashMap<Integer, String>();
    }

    public void setType(int parameterIndex, String typeId) {
        this.setType(parameterIndex, this.session.getTypeDefinition(typeId));
    }

    public void setType(int parameterIndex, ObjectType type) {
        if (type == null) {
            throw new IllegalArgumentException("Type must be set!");
        }
        String queryName = type.getQueryName();
        if (queryName == null) {
            throw new IllegalArgumentException("Type has no query name!");
        }
        this.parametersMap.put(parameterIndex, queryName);
    }

    public void setProperty(int parameterIndex, String typeId, String propertyId) {
        ObjectType type = this.session.getTypeDefinition(typeId);
        PropertyDefinition propertyDefinition = (PropertyDefinition)type.getPropertyDefinitions().get(propertyId);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("Property does not exist!");
        }
        this.setProperty(parameterIndex, propertyDefinition);
    }

    public void setProperty(int parameterIndex, PropertyDefinition<?> propertyDefinition) {
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("Property must be set!");
        }
        String queryName = propertyDefinition.getQueryName();
        if (queryName == null) {
            throw new IllegalArgumentException("Property has no query name!");
        }
        this.parametersMap.put(parameterIndex, queryName);
    }

    public void setNumber(int parameterIndex, Number ... num) {
        if (num == null || num.length == 0) {
            throw new IllegalArgumentException("Number must be set!");
        }
        StringBuilder sb = new StringBuilder();
        for (Number n : num) {
            if (n == null) {
                throw new IllegalArgumentException("Number is null!");
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(n.toString());
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public void setString(int parameterIndex, String ... str) {
        if (str == null || str.length == 0) {
            throw new IllegalArgumentException("String must be set!");
        }
        StringBuilder sb = new StringBuilder();
        for (String s : str) {
            if (s == null) {
                throw new IllegalArgumentException("String is null!");
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(QueryStatementImpl.escape(s));
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public void setStringLike(int parameterIndex, String str) {
        if (str == null) {
            throw new IllegalArgumentException("String must be set!");
        }
        this.parametersMap.put(parameterIndex, QueryStatementImpl.escapeLike(str));
    }

    public void setId(int parameterIndex, ObjectId ... id) {
        if (id == null || id.length == 0) {
            throw new IllegalArgumentException("Id must be set!");
        }
        StringBuilder sb = new StringBuilder();
        for (ObjectId oid : id) {
            if (oid == null || oid.getId() == null) {
                throw new IllegalArgumentException("Id is null!");
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(QueryStatementImpl.escape(oid.getId()));
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public void setUri(int parameterIndex, URI ... uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must be set!");
        }
        StringBuilder sb = new StringBuilder();
        for (URI u : uri) {
            if (u == null) {
                throw new IllegalArgumentException("URI is null!");
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(QueryStatementImpl.escape(u.toString()));
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public void setUrl(int parameterIndex, URL ... url) {
        if (url == null) {
            throw new IllegalArgumentException("URL must be set!");
        }
        StringBuilder sb = new StringBuilder();
        for (URL u : url) {
            if (u == null) {
                throw new IllegalArgumentException("URI is null!");
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(QueryStatementImpl.escape(u.toString()));
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public void setBoolean(int parameterIndex, boolean ... bool) {
        if (bool == null || bool.length == 0) {
            throw new IllegalArgumentException("Boolean must not be set!");
        }
        StringBuilder sb = new StringBuilder();
        for (boolean b : bool) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(b ? "TRUE" : "FALSE");
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public void setDateTime(int parameterIndex, Calendar ... cal) {
        if (cal == null || cal.length == 0) {
            throw new IllegalArgumentException("Calendar must be set!");
        }
        StringBuilder sb = new StringBuilder();
        for (Calendar c : cal) {
            if (c == null) {
                throw new IllegalArgumentException("DateTime is null!");
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(QueryStatementImpl.convert(c.getTime()));
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public void setDateTime(int parameterIndex, Date ... date) {
        if (date == null || date.length == 0) {
            throw new IllegalArgumentException("Date must be set!");
        }
        StringBuilder sb = new StringBuilder();
        for (Date d : date) {
            if (d == null) {
                throw new IllegalArgumentException("DateTime is null!");
            }
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(QueryStatementImpl.convert(d));
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public void setDateTime(int parameterIndex, long ... ms) {
        if (ms == null || ms.length == 0) {
            throw new IllegalArgumentException("Timestamp must be set!");
        }
        StringBuilder sb = new StringBuilder();
        for (long l : ms) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(QueryStatementImpl.convert(new Date(l)));
        }
        this.parametersMap.put(parameterIndex, sb.toString());
    }

    public String toQueryString() {
        boolean inStr = false;
        int parameterIndex = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.statement.length(); ++i) {
            char c = this.statement.charAt(i);
            if (c == '\'') {
                if (inStr && this.statement.charAt(i - 1) == '\\') {
                    inStr = true;
                    continue;
                }
                inStr = !inStr;
                continue;
            }
            if (c == '?') {
                String s;
                if ((s = this.parametersMap.get(++parameterIndex)) == null) {
                    sb.append(c);
                    continue;
                }
                sb.append(s);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public ItemIterable<QueryResult> query(boolean searchAllVersions) {
        return this.session.query(this.toQueryString(), searchAllVersions);
    }

    public ItemIterable<QueryResult> query(boolean searchAllVersions, OperationContext context) {
        return this.session.query(this.toQueryString(), searchAllVersions, context);
    }

    protected Object clone() throws CloneNotSupportedException {
        QueryStatementImpl qs = new QueryStatementImpl(this.session, this.statement);
        qs.parametersMap.putAll(this.parametersMap);
        return qs;
    }

    public String toString() {
        return this.toQueryString();
    }

    private static String escape(String str) {
        StringBuilder sb = new StringBuilder("'");
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'' || c == '\\') {
                sb.append("\\");
            }
            sb.append(c);
        }
        sb.append("'");
        return sb.toString();
    }

    private static String escapeLike(String str) {
        StringBuilder sb = new StringBuilder("'");
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'') {
                sb.append("\\");
            } else if (c == '\\' && (i + 1 >= str.length() || str.charAt(i + 1) != '%' && str.charAt(i + 1) != '_')) {
                sb.append("\\");
            }
            sb.append(c);
        }
        sb.append("'");
        return sb.toString();
    }

    private static String convert(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return "'" + sdf.format(date) + "'";
    }
}

