/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.PageLock;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.auth.WikiPrincipal;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.acl.Acl;
import com.ecyrd.jspwiki.auth.acl.AclEntry;
import com.ecyrd.jspwiki.auth.acl.AclEntryImpl;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiPageEvent;
import com.ecyrd.jspwiki.event.WikiSecurityEvent;
import com.ecyrd.jspwiki.modules.ModuleManager;
import com.ecyrd.jspwiki.providers.CachingProvider;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.RepositoryModifiedException;
import com.ecyrd.jspwiki.providers.WikiPageProvider;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.ecyrd.jspwiki.util.WikiBackgroundThread;
import com.ecyrd.jspwiki.workflow.Outcome;
import com.ecyrd.jspwiki.workflow.Task;
import com.ecyrd.jspwiki.workflow.Workflow;
import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class PageManager
extends ModuleManager
implements WikiEventListener {
    private static final long serialVersionUID = 1L;
    public static final String PROP_PAGEPROVIDER = "jspwiki.pageProvider";
    public static final String PROP_USECACHE = "jspwiki.usePageCache";
    public static final String PROP_LOCKEXPIRY = "jspwiki.lockExpiryTime";
    public static final String PRESAVE_TASK_MESSAGE_KEY = "task.preSaveWikiPage";
    public static final String PRESAVE_WIKI_CONTEXT = "wikiContext";
    public static final String SAVE_APPROVER = "workflow.saveWikiPage";
    public static final String SAVE_DECISION_MESSAGE_KEY = "decision.saveWikiPage";
    public static final String SAVE_REJECT_MESSAGE_KEY = "notification.saveWikiPage.reject";
    public static final String SAVE_TASK_MESSAGE_KEY = "task.saveWikiPage";
    public static final String FACT_PAGE_NAME = "fact.pageName";
    public static final String FACT_DIFF_TEXT = "fact.diffText";
    public static final String FACT_CURRENT_TEXT = "fact.currentText";
    public static final String FACT_PROPOSED_TEXT = "fact.proposedText";
    public static final String FACT_IS_AUTHENTICATED = "fact.isAuthenticated";
    static Logger log = Logger.getLogger(PageManager.class);
    private WikiPageProvider m_provider;
    protected HashMap<String, PageLock> m_pageLocks = new HashMap();
    private WikiEngine m_engine;
    private int m_expiryTime = 60;
    private LockReaper m_reaper = null;

    public PageManager(WikiEngine engine, Properties props) throws WikiException {
        super(engine);
        this.m_engine = engine;
        boolean useCache = "true".equals(props.getProperty(PROP_USECACHE));
        this.m_expiryTime = TextUtil.parseIntParameter(props.getProperty(PROP_LOCKEXPIRY), 60);
        String classname = useCache ? "com.ecyrd.jspwiki.providers.CachingProvider" : WikiEngine.getRequiredProperty(props, PROP_PAGEPROVIDER);
        try {
            log.debug((Object)("Page provider class: '" + classname + "'"));
            Class providerclass = ClassUtil.findClass("com.ecyrd.jspwiki.providers", classname);
            this.m_provider = (WikiPageProvider)providerclass.newInstance();
            log.debug((Object)("Initializing page provider class " + this.m_provider));
            this.m_provider.initialize(this.m_engine, props);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to locate provider class '" + classname + "'"), (Throwable)e);
            throw new WikiException("No provider class.", e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Unable to create provider class '" + classname + "'"), (Throwable)e);
            throw new WikiException("Faulty provider class.", e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to provider class '" + classname + "'"), (Throwable)e);
            throw new WikiException("Illegal provider class.", e);
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)("Provider did not found a property it was looking for: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)("An I/O exception occurred while trying to create a new page provider: " + classname), (Throwable)e);
            throw new WikiException("Unable to start page provider: " + e.getMessage(), e);
        }
    }

    public WikiPageProvider getProvider() {
        return this.m_provider;
    }

    public Collection getAllPages() throws ProviderException {
        return this.m_provider.getAllPages();
    }

    public String getPageText(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        String text = null;
        try {
            text = this.m_provider.getPageText(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            log.info((Object)("Repository has been modified externally while fetching page " + pageName));
            WikiPage p = this.m_provider.getPageInfo(pageName, version);
            this.m_engine.updateReferences(p);
            if (p != null) {
                this.m_engine.getSearchManager().reindexPage(p);
                text = this.m_provider.getPageText(pageName, version);
            }
            WikiPage dummy = new WikiPage(this.m_engine, pageName);
            this.m_engine.getSearchManager().pageRemoved(dummy);
            this.m_engine.getReferenceManager().pageRemoved(dummy);
        }
        return text;
    }

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    public void putPageText(WikiPage page, String content) throws ProviderException {
        if (page == null || page.getName() == null || page.getName().length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        this.m_provider.putPageText(page, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageLock lockPage(WikiPage page, String user) {
        PageLock lock = null;
        if (this.m_reaper == null) {
            this.m_reaper = new LockReaper(this.m_engine);
            this.m_reaper.start();
        }
        HashMap<String, PageLock> hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            this.fireEvent(10, page.getName());
            lock = this.m_pageLocks.get(page.getName());
            if (lock == null) {
                Date d = new Date();
                lock = new PageLock(page, user, d, new Date(d.getTime() + (long)(this.m_expiryTime * 60) * 1000L));
                this.m_pageLocks.put(page.getName(), lock);
                log.debug((Object)("Locked page " + page.getName() + " for " + user));
            } else {
                log.debug((Object)("Page " + page.getName() + " already locked by " + lock.getLocker()));
                lock = null;
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockPage(PageLock lock) {
        if (lock == null) {
            return;
        }
        HashMap<String, PageLock> hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            this.m_pageLocks.remove(lock.getPage());
            log.debug((Object)("Unlocked page " + lock.getPage()));
        }
        this.fireEvent(11, lock.getPage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageLock getCurrentLock(WikiPage page) {
        PageLock lock = null;
        HashMap<String, PageLock> hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            lock = this.m_pageLocks.get(page.getName());
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveLocks() {
        ArrayList<PageLock> result = new ArrayList<PageLock>();
        HashMap<String, PageLock> hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            for (PageLock lock : this.m_pageLocks.values()) {
                result.add(lock);
            }
        }
        return result;
    }

    public WikiPage getPageInfo(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name '" + pageName + "'");
        }
        WikiPage page = null;
        try {
            page = this.m_provider.getPageInfo(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            log.info((Object)("Repository has been modified externally while fetching info for " + pageName));
            page = this.m_provider.getPageInfo(pageName, version);
            if (page != null) {
                this.m_engine.updateReferences(page);
            }
            this.m_engine.getReferenceManager().pageRemoved(new WikiPage(this.m_engine, pageName));
        }
        return page;
    }

    public List getVersionHistory(String pageName) throws ProviderException {
        if (this.pageExists(pageName)) {
            return this.m_provider.getVersionHistory(pageName);
        }
        return null;
    }

    public String getProviderDescription() {
        return this.m_provider.getProviderInfo();
    }

    public int getTotalPageCount() {
        try {
            return this.m_provider.getAllPages().size();
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to count pages: ", (Throwable)e);
            return -1;
        }
    }

    public boolean pageExists(String pageName) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        return this.m_provider.pageExists(pageName);
    }

    public boolean pageExists(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        if (version == -1) {
            return this.pageExists(pageName);
        }
        if (this.m_provider instanceof CachingProvider) {
            return ((CachingProvider)this.m_provider).pageExists(pageName, version);
        }
        return this.m_provider.getPageInfo(pageName, version) != null;
    }

    public void deleteVersion(WikiPage page) throws ProviderException {
        this.m_provider.deleteVersion(page.getName(), page.getVersion());
    }

    public void deletePage(WikiPage page) throws ProviderException {
        this.fireEvent(26, page.getName());
        this.m_provider.deletePage(page.getName());
        this.fireEvent(27, page.getName());
    }

    protected final void fireEvent(int type, String pagename) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiPageEvent(this.m_engine, type, pagename));
        }
    }

    public Collection modules() {
        return null;
    }

    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiSecurityEvent)) {
            return;
        }
        WikiSecurityEvent se = (WikiSecurityEvent)event;
        if (se.getType() == 54) {
            UserProfile[] profiles = (UserProfile[])se.getTarget();
            Principal[] oldPrincipals = new Principal[]{new WikiPrincipal(profiles[0].getLoginName()), new WikiPrincipal(profiles[0].getFullname()), new WikiPrincipal(profiles[0].getWikiName())};
            WikiPrincipal newPrincipal = new WikiPrincipal(profiles[1].getFullname());
            try {
                int pagesChanged = 0;
                Collection pages = this.getAllPages();
                for (WikiPage page : pages) {
                    boolean aclChanged = this.changeAcl(page, oldPrincipals, newPrincipal);
                    if (!aclChanged) continue;
                    try {
                        this.m_engine.getAclManager().setPermissions(page, page.getAcl());
                    }
                    catch (WikiSecurityException e) {
                        log.error((Object)("Could not change page ACL for page " + page.getName() + ": " + e.getMessage()));
                    }
                    ++pagesChanged;
                }
                log.info((Object)("Profile name change for '" + ((Object)newPrincipal).toString() + "' caused " + pagesChanged + " page ACLs to change also."));
            }
            catch (ProviderException e) {
                log.error((Object)("Could not change user name in Page ACLs because of Provider error:" + e.getMessage()));
            }
        }
    }

    protected boolean changeAcl(WikiPage page, Principal[] oldPrincipals, Principal newPrincipal) {
        Acl acl = page.getAcl();
        boolean pageChanged = false;
        if (acl != null) {
            Enumeration entries = acl.entries();
            ArrayList<AclEntryImpl> entriesToAdd = new ArrayList<AclEntryImpl>();
            ArrayList<AclEntry> entriesToRemove = new ArrayList<AclEntry>();
            while (entries.hasMoreElements()) {
                AclEntry entry = (AclEntry)entries.nextElement();
                if (!ArrayUtils.contains((Object[])oldPrincipals, (Object)entry.getPrincipal())) continue;
                AclEntryImpl aclEntryImpl = new AclEntryImpl();
                aclEntryImpl.setPrincipal(newPrincipal);
                Enumeration permissions = entry.permissions();
                while (permissions.hasMoreElements()) {
                    Permission permission = (Permission)permissions.nextElement();
                    aclEntryImpl.addPermission(permission);
                }
                pageChanged = true;
                entriesToRemove.add(entry);
                entriesToAdd.add(aclEntryImpl);
            }
            for (AclEntry aclEntry : entriesToRemove) {
                acl.removeEntry(aclEntry);
            }
            for (AclEntry aclEntry : entriesToAdd) {
                acl.addEntry(aclEntry);
            }
        }
        return pageChanged;
    }

    public static class SaveWikiPageTask
    extends Task {
        private static final long serialVersionUID = 3190559953484411420L;

        public SaveWikiPageTask() {
            super(PageManager.SAVE_TASK_MESSAGE_KEY);
        }

        public Outcome execute() throws WikiException {
            WikiContext context = (WikiContext)this.getWorkflow().getAttribute(PageManager.PRESAVE_WIKI_CONTEXT);
            String proposedText = (String)this.getWorkflow().getAttribute(PageManager.FACT_PROPOSED_TEXT);
            WikiEngine engine = context.getEngine();
            WikiPage page = context.getPage();
            engine.getPageManager().putPageText(page, proposedText);
            engine.getPage(page.getName());
            engine.textToHTML(context, proposedText);
            engine.getFilterManager().doPostSaveFiltering(context, proposedText);
            return Outcome.STEP_COMPLETE;
        }
    }

    public static class PreSaveWikiPageTask
    extends Task {
        private static final long serialVersionUID = 6304715570092804615L;
        private final WikiContext m_context;
        private final String m_proposedText;

        public PreSaveWikiPageTask(WikiContext context, String proposedText) {
            super(PageManager.PRESAVE_TASK_MESSAGE_KEY);
            this.m_context = context;
            this.m_proposedText = proposedText;
        }

        public Outcome execute() throws WikiException {
            Principal wup;
            WikiEngine engine = this.m_context.getEngine();
            Workflow workflow = this.getWorkflow();
            WikiPage page = this.m_context.getPage();
            if (page.getAuthor() == null && (wup = this.m_context.getCurrentUser()) != null) {
                page.setAuthor(wup.getName());
            }
            String saveText = engine.getFilterManager().doPreSaveFiltering(this.m_context, this.m_proposedText);
            workflow.setAttribute(PageManager.PRESAVE_WIKI_CONTEXT, this.m_context);
            workflow.setAttribute(PageManager.FACT_PROPOSED_TEXT, saveText);
            return Outcome.STEP_COMPLETE;
        }
    }

    private class LockReaper
    extends WikiBackgroundThread {
        public LockReaper(WikiEngine engine) {
            super(engine, 60);
            this.setName("JSPWiki Lock Reaper");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void backgroundTask() throws Exception {
            HashMap<String, PageLock> hashMap = PageManager.this.m_pageLocks;
            synchronized (hashMap) {
                Collection<PageLock> entries = PageManager.this.m_pageLocks.values();
                Date now = new Date();
                Iterator<PageLock> i = entries.iterator();
                while (i.hasNext()) {
                    PageLock p = i.next();
                    if (!now.after(p.getExpiryTime())) continue;
                    i.remove();
                    log.debug((Object)("Reaped lock: " + p.getPage() + " by " + p.getLocker() + ", acquired " + p.getAcquisitionTime() + ", and expired " + p.getExpiryTime()));
                }
            }
        }
    }
}

