/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.SearchResult;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.apache.log4j.Logger;

public class Search
implements WikiPlugin {
    static Logger log = Logger.getLogger(Search.class);
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_SET = "set";
    public static final String DEFAULT_SETNAME = "_defaultSet";
    public static final String PARAM_MAX = "max";

    public String execute(WikiContext context, Map params) throws PluginException {
        int maxItems = Integer.MAX_VALUE;
        Collection results = null;
        String queryString = (String)params.get(PARAM_QUERY);
        String set = (String)params.get(PARAM_SET);
        String max = (String)params.get(PARAM_MAX);
        if (set == null) {
            set = DEFAULT_SETNAME;
        }
        if (max != null) {
            maxItems = Integer.parseInt(max);
        }
        if (queryString == null) {
            results = (Collection)context.getVariable(set);
        } else {
            try {
                results = this.doBasicQuery(context, queryString);
                context.setVariable(set, results);
            }
            catch (Exception e) {
                return "<div class='error'>" + e.getMessage() + "</div>\n";
            }
        }
        String res = "";
        if (results != null) {
            res = this.renderResults(results, context, maxItems);
        }
        return res;
    }

    private Collection doBasicQuery(WikiContext context, String query) throws ProviderException, IOException {
        log.debug((Object)("Searching for string " + query));
        Collection list = context.getEngine().findPages(query);
        return list;
    }

    private String renderResults(Collection results, WikiContext context, int maxItems) {
        WikiEngine engine = context.getEngine();
        table t = new table();
        t.setBorder(0);
        t.setCellPadding(4);
        tr row = new tr();
        t.addElement((Element)row);
        row.addElement((Element)new th().setWidth("30%").setAlign("left").addElement("Page"));
        row.addElement((Element)new th().setAlign("left").addElement("Score"));
        int idx = 0;
        Iterator i = results.iterator();
        while (i.hasNext() && idx++ <= maxItems) {
            SearchResult sr = (SearchResult)i.next();
            row = new tr();
            td name = new td().setWidth("30%");
            name.addElement("<a href=\"" + context.getURL(WikiContext.VIEW, sr.getPage().getName()) + "\">" + engine.beautifyTitle(sr.getPage().getName()) + "</a>");
            row.addElement((Element)name);
            row.addElement((Element)new td().addElement("" + sr.getScore()));
            t.addElement((Element)row);
        }
        if (results.isEmpty()) {
            row = new tr();
            row.addElement((Element)new td().setColSpan(2).addElement((Element)new b().addElement("No results")));
            t.addElement((Element)row);
        }
        return t.toString();
    }
}

