/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.search;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.SearchResult;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.event.WikiEvent;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventUtils;
import com.ecyrd.jspwiki.event.WikiPageEvent;
import com.ecyrd.jspwiki.filters.BasicPageFilter;
import com.ecyrd.jspwiki.filters.FilterException;
import com.ecyrd.jspwiki.modules.InternalModule;
import com.ecyrd.jspwiki.parser.MarkupParser;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.rpc.RPCCallable;
import com.ecyrd.jspwiki.rpc.json.JSONRPCManager;
import com.ecyrd.jspwiki.search.BasicSearchProvider;
import com.ecyrd.jspwiki.search.LuceneSearchProvider;
import com.ecyrd.jspwiki.search.SearchProvider;
import com.ecyrd.jspwiki.util.ClassUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;

public class SearchManager
extends BasicPageFilter
implements InternalModule,
WikiEventListener {
    private static final Logger log = Logger.getLogger(SearchManager.class);
    private static final String DEFAULT_SEARCHPROVIDER = "com.ecyrd.jspwiki.search.LuceneSearchProvider";
    private static final String PROP_USE_LUCENE = "jspwiki.useLucene";
    public static final String PROP_SEARCHPROVIDER = "jspwiki.searchProvider";
    private SearchProvider m_searchProvider = null;
    public static final String JSON_SEARCH = "search";

    public SearchManager(WikiEngine engine, Properties properties) throws WikiException {
        this.initialize(engine, properties);
        WikiEventUtils.addWikiEventListener(this.m_engine.getPageManager(), 26, this);
        JSONRPCManager.registerGlobalObject(JSON_SEARCH, new JSONSearch());
    }

    public void initialize(WikiEngine engine, Properties properties) throws FilterException {
        this.m_engine = engine;
        this.loadSearchProvider(properties);
        try {
            this.m_searchProvider.initialize(engine, properties);
        }
        catch (NoRequiredPropertyException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadSearchProvider(Properties properties) {
        String useLucene = properties.getProperty(PROP_USE_LUCENE);
        if (useLucene != null) {
            log.info((Object)"jspwiki.useLucene is deprecated; please use jspwiki.searchProvider=<your search provider> instead.");
            this.m_searchProvider = TextUtil.isPositive(useLucene) ? new LuceneSearchProvider() : new BasicSearchProvider();
            log.debug((Object)("useLucene was set, loading search provider " + this.m_searchProvider));
            return;
        }
        String providerClassName = properties.getProperty(PROP_SEARCHPROVIDER, DEFAULT_SEARCHPROVIDER);
        try {
            Class providerClass = ClassUtil.findClass("com.ecyrd.jspwiki.search", providerClassName);
            this.m_searchProvider = (SearchProvider)providerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"Failed loading SearchProvider, will use BasicSearchProvider.", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.warn((Object)"Failed loading SearchProvider, will use BasicSearchProvider.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"Failed loading SearchProvider, will use BasicSearchProvider.", (Throwable)e);
        }
        if (null == this.m_searchProvider) {
            this.m_searchProvider = new BasicSearchProvider();
        }
        log.debug((Object)("Loaded search provider " + this.m_searchProvider));
    }

    public SearchProvider getSearchEngine() {
        return this.m_searchProvider;
    }

    public Collection findPages(String query) throws ProviderException, IOException {
        if (query == null) {
            query = "";
        }
        Collection c = this.m_searchProvider.findPages(query);
        return c;
    }

    public void pageRemoved(WikiPage page) {
        this.m_searchProvider.pageRemoved(page);
    }

    public void postSave(WikiContext wikiContext, String content) {
        WikiPage p = this.m_engine.getPage(wikiContext.getPage().getName());
        this.reindexPage(p);
    }

    public void reindexPage(WikiPage page) {
        this.m_searchProvider.reindexPage(page);
    }

    public void actionPerformed(WikiEvent event) {
        String pageName;
        WikiPage p;
        if (event instanceof WikiPageEvent && event.getType() == 26 && (p = this.m_engine.getPage(pageName = ((WikiPageEvent)event).getPageName())) != null) {
            this.pageRemoved(p);
        }
    }

    public class JSONSearch
    implements RPCCallable {
        public List getSuggestions(String wikiName, int maxLength) {
            StopWatch sw = new StopWatch();
            sw.start();
            ArrayList<String> list = new ArrayList<String>(maxLength);
            if (wikiName.length() > 0) {
                String filename = "";
                int pos = wikiName.indexOf("/");
                if (pos >= 0) {
                    filename = wikiName.substring(pos).toLowerCase();
                    wikiName = wikiName.substring(0, pos);
                }
                String cleanWikiName = MarkupParser.cleanLink(wikiName).toLowerCase() + filename;
                String oldStyleName = MarkupParser.wikifyLink(wikiName).toLowerCase() + filename;
                Set allPages = SearchManager.this.m_engine.getReferenceManager().findCreated();
                int counter = 0;
                Iterator i = allPages.iterator();
                while (i.hasNext() && counter < maxLength) {
                    String p = (String)i.next();
                    String pp = p.toLowerCase();
                    if (!pp.startsWith(cleanWikiName) && !pp.startsWith(oldStyleName)) continue;
                    list.add(p);
                    ++counter;
                }
            }
            sw.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Suggestion request for " + wikiName + " done in " + sw));
            }
            return list;
        }

        public List findPages(String searchString, int maxLength) {
            StopWatch sw = new StopWatch();
            sw.start();
            ArrayList list = new ArrayList(maxLength);
            if (searchString.length() > 0) {
                try {
                    Collection c = SearchManager.this.m_searchProvider instanceof LuceneSearchProvider ? ((LuceneSearchProvider)SearchManager.this.m_searchProvider).findPages(searchString, 0) : SearchManager.this.m_searchProvider.findPages(searchString);
                    Iterator i = c.iterator();
                    for (int count = 0; i.hasNext() && count < maxLength; ++count) {
                        SearchResult sr = (SearchResult)i.next();
                        HashMap<String, Object> hm = new HashMap<String, Object>();
                        hm.put("page", sr.getPage().getName());
                        hm.put("score", sr.getScore());
                        list.add(hm);
                    }
                }
                catch (Exception e) {
                    log.info((Object)"AJAX search failed; ", (Throwable)e);
                }
            }
            sw.stop();
            if (log.isDebugEnabled()) {
                log.debug((Object)("AJAX search complete in " + sw));
            }
            return list;
        }
    }
}

