/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.model;

import com.lowagie.rups.model.Permissions;
import com.lowagie.text.DocumentException;
import com.lowagie.text.exceptions.BadPasswordException;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class PdfFile {
    protected File directory = null;
    protected String filename = null;
    protected PdfReader reader = null;
    protected Permissions permissions = null;

    public PdfFile(File file) throws IOException, DocumentException {
        if (file == null) {
            throw new IOException("No file selected.");
        }
        RandomAccessFileOrArray pdf = new RandomAccessFileOrArray(file.getAbsolutePath());
        this.directory = file.getParentFile();
        this.filename = file.getName();
        this.readFile(pdf);
    }

    public PdfFile(byte[] file) throws IOException, DocumentException {
        RandomAccessFileOrArray pdf = new RandomAccessFileOrArray(file);
        this.readFile(pdf);
    }

    protected void readFile(RandomAccessFileOrArray pdf) throws IOException, DocumentException {
        this.permissions = new Permissions();
        try {
            this.reader = new PdfReader(pdf, null);
            this.permissions.setEncrypted(false);
        }
        catch (BadPasswordException bpe) {
            JPasswordField passwordField = new JPasswordField(32);
            JOptionPane.showConfirmDialog(null, passwordField, "Enter the User or Owner Password of this PDF file", 2);
            byte[] password = new String(passwordField.getPassword()).getBytes();
            this.reader = new PdfReader(pdf, password);
            this.permissions.setEncrypted(true);
            this.permissions.setCryptoMode(this.reader.getCryptoMode());
            this.permissions.setPermissions(this.reader.getPermissions());
            if (this.reader.isOpenedWithFullPermissions()) {
                this.permissions.setOwnerPassword(password);
                this.permissions.setUserPassword(this.reader.computeUserPassword());
            }
            throw new IOException("You need the owner password of this file to open it in iText Trapeze.");
        }
    }

    public PdfReader getPdfReader() {
        return this.reader;
    }
}

