/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.management.DevModeClassLoader;
import net.sf.ehcache.management.ManagementServer;
import net.sf.ehcache.management.ResourceClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementServerLoader {
    private static final String PRIVATE_CLASSPATH = "rest-management-private-classpath";
    private static final Map<String, Object> MGMT_SVR_BY_BIND = new HashMap<String, Object>();
    private static final ClassLoader RESOURCE_CLASS_LOADER;
    private static final Logger LOG;

    public static boolean isManagementAvailable() {
        try {
            ServiceLoader<ManagementServer> loader = ServiceLoader.load(ManagementServer.class, RESOURCE_CLASS_LOADER);
            Iterator<ManagementServer> loaderIterator = loader.iterator();
            if (loaderIterator.hasNext()) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to load META-INF/services/net.sf.ehcache.management.ManagementServer ; the management agent won't be available");
        }
        return false;
    }

    public static void register(CacheManager cacheManager, String clientUUID, ManagementRESTServiceConfiguration managementRESTServiceConfiguration) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object managementServerImpl;
            Thread.currentThread().setContextClassLoader(RESOURCE_CLASS_LOADER);
            Class<?> managementServerImplClass = RESOURCE_CLASS_LOADER.loadClass("net.sf.ehcache.management.ManagementServer");
            if (!MGMT_SVR_BY_BIND.containsKey(managementRESTServiceConfiguration.getBind())) {
                if (!MGMT_SVR_BY_BIND.isEmpty()) {
                    String alreadyBound = MGMT_SVR_BY_BIND.keySet().iterator().next();
                    managementRESTServiceConfiguration.setBind(alreadyBound);
                    LOG.warn("You can not have several Ehcache management rest agents running in the same ClassLoader; CacheManager " + cacheManager.getName() + " will be registered to the already running Ehcache management rest agent listening on port " + alreadyBound + ", the configuration will not be changed");
                } else {
                    managementServerImpl = ManagementServerLoader.loadOSorEEManagementServer();
                    ManagementServerLoader.startRestAgent(managementRESTServiceConfiguration, managementServerImplClass, managementServerImpl, clientUUID);
                }
            } else {
                LOG.warn("A previous CacheManager already instantiated the Ehcache Management rest agent" + ("".equals(managementRESTServiceConfiguration.getBind()) ? ", reachable only through the TSA agent" : ", on port " + managementRESTServiceConfiguration.getBind()) + ", the configuration will not be changed for " + cacheManager.getName());
            }
            managementServerImpl = MGMT_SVR_BY_BIND.get(managementRESTServiceConfiguration.getBind());
            Method registerMethod = managementServerImplClass.getMethod("register", cacheManager.getClass());
            registerMethod.invoke(managementServerImpl, cacheManager);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw new RuntimeException("Failed to initialize the ManagementRESTService - Did you include ehcache-rest-agent on the classpath?", e);
            }
            throw new RuntimeException("Failed to instantiate ManagementServer.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static Object loadOSorEEManagementServer() throws Exception {
        ManagementServer managementServerImpl;
        ServiceLoader<ManagementServer> loader = ServiceLoader.load(ManagementServer.class, RESOURCE_CLASS_LOADER);
        Iterator<ManagementServer> loaderIterator = loader.iterator();
        if (!loaderIterator.hasNext()) {
            LOG.info("Could not find any META-INF/services/net.sf.ehcache.management.ManagementServer using the ResourceClassLoader; choosing the default OS implementation : net.sf.ehcache.management.ManagementServerImpl");
            Class<?> managementServerImplClass = RESOURCE_CLASS_LOADER.loadClass("net.sf.ehcache.management.ManagementServerImpl");
            Constructor<?> managementServerImplClassConstructor = managementServerImplClass.getConstructor(new Class[0]);
            managementServerImpl = managementServerImplClassConstructor.newInstance(new Object[0]);
        } else {
            managementServerImpl = loaderIterator.next();
            if (loaderIterator.hasNext()) {
                throw new RuntimeException("Several META-INF/services/net.sf.ehcache.management.ManagementServer found in the classpath, aborting agent start up");
            }
            LOG.info("The ManagementServer implementation that is going to be used is {} .", (Object)managementServerImpl.getClass().toString());
        }
        return managementServerImpl;
    }

    private static void startRestAgent(ManagementRESTServiceConfiguration managementRESTServiceConfiguration, Class<?> managementServerImplClass, Object managementServerImpl, String clientUUID) throws Exception {
        Method initializeMethod = managementServerImplClass.getMethod("initialize", String.class, managementRESTServiceConfiguration.getClass());
        initializeMethod.invoke(managementServerImpl, clientUUID, managementRESTServiceConfiguration);
        Method startMethod = managementServerImplClass.getMethod("start", new Class[0]);
        startMethod.invoke(managementServerImpl, new Object[0]);
        MGMT_SVR_BY_BIND.put(managementRESTServiceConfiguration.getBind(), managementServerImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String registeredMgmtSvrBind, CacheManager cacheManager) {
        Object managementServerImpl = MGMT_SVR_BY_BIND.get(registeredMgmtSvrBind);
        boolean removeMgmtSvr = false;
        try {
            Class<?> managementServerImplClass = RESOURCE_CLASS_LOADER.loadClass("net.sf.ehcache.management.ManagementServer");
            Method registerMethod = managementServerImplClass.getMethod("unregister", cacheManager.getClass());
            registerMethod.invoke(managementServerImpl, cacheManager);
            Method hasRegisteredMethod = managementServerImplClass.getMethod("hasRegistered", new Class[0]);
            Boolean hasRegistered = (Boolean)hasRegisteredMethod.invoke(managementServerImpl, new Object[0]);
            if (!hasRegistered.booleanValue()) {
                removeMgmtSvr = true;
                Method stopMethod = managementServerImplClass.getMethod("stop", new Class[0]);
                stopMethod.invoke(managementServerImpl, new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to shutdown the ManagementRESTService", (Throwable)e);
        }
        finally {
            if (removeMgmtSvr) {
                MGMT_SVR_BY_BIND.remove(registeredMgmtSvrBind);
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ManagementServerLoader.class);
        URL depsResource = DevModeClassLoader.devModeResource();
        RESOURCE_CLASS_LOADER = depsResource != null ? new DevModeClassLoader(depsResource, CacheManager.class.getClassLoader()) : new ResourceClassLoader(PRIVATE_CLASSPATH, CacheManager.class.getClassLoader());
        LOG.debug("XXX: using classloader: " + RESOURCE_CLASS_LOADER);
    }
}

