/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

import com.jhlabs.image.ImageMath;
import com.jhlabs.math.Function1D;
import com.jhlabs.math.Function2D;
import com.jhlabs.math.Function3D;
import java.util.Random;

public class Noise
implements Function1D,
Function2D,
Function3D {
    private static Random randomGenerator = new Random();
    private static final int B = 256;
    private static final int BM = 255;
    private static final int N = 4096;
    static int[] p = new int[514];
    static double[][] g3 = new double[514][3];
    static double[][] g2 = new double[514][2];
    static double[] g1 = new double[514];
    static boolean start = true;

    public double evaluate(double d) {
        return Noise.noise1(d);
    }

    public double evaluate(double d, double d2) {
        return Noise.noise2(d, d2);
    }

    public double evaluate(double d, double d2, double d3) {
        return this.noise3(d, d2, d3);
    }

    public static double turbulence2(double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 1.0;
        while (d5 <= d3) {
            d4 += Math.abs(Noise.noise2(d5 * d, d5 * d2)) / d5;
            d5 *= 2.0;
        }
        return d4;
    }

    private static double sCurve(double d) {
        return d * d * (3.0 - 2.0 * d);
    }

    public static double noise1(double d) {
        if (start) {
            start = false;
            Noise.init();
        }
        double d2 = d + 4096.0;
        int n = (int)d2 & 0xFF;
        int n2 = n + 1 & 0xFF;
        double d3 = d2 - (double)((int)d2);
        double d4 = d3 - 1.0;
        double d5 = Noise.sCurve(d3);
        double d6 = d3 * g1[p[n]];
        double d7 = d4 * g1[p[n2]];
        return 2.3 * ImageMath.lerp(d5, d6, d7);
    }

    public static double noise2(double d, double d2) {
        if (start) {
            start = false;
            Noise.init();
        }
        double d3 = d + 4096.0;
        int n = (int)d3 & 0xFF;
        int n2 = n + 1 & 0xFF;
        double d4 = d3 - (double)((int)d3);
        double d5 = d4 - 1.0;
        d3 = d2 + 4096.0;
        int n3 = (int)d3 & 0xFF;
        int n4 = n3 + 1 & 0xFF;
        double d6 = d3 - (double)((int)d3);
        double d7 = d6 - 1.0;
        int n5 = p[n];
        int n6 = p[n2];
        int n7 = p[n5 + n3];
        int n8 = p[n6 + n3];
        int n9 = p[n5 + n4];
        int n10 = p[n6 + n4];
        double d8 = Noise.sCurve(d4);
        double d9 = Noise.sCurve(d6);
        double[] dArray = g2[n7];
        double d10 = d4 * dArray[0] + d6 * dArray[1];
        dArray = g2[n8];
        double d11 = d5 * dArray[0] + d6 * dArray[1];
        double d12 = ImageMath.lerp(d8, d10, d11);
        dArray = g2[n9];
        d10 = d4 * dArray[0] + d7 * dArray[1];
        dArray = g2[n10];
        d11 = d5 * dArray[0] + d7 * dArray[1];
        double d13 = ImageMath.lerp(d8, d10, d11);
        return 1.5 * ImageMath.lerp(d9, d12, d13);
    }

    public double noise3(double d, double d2, double d3) {
        if (start) {
            start = false;
            Noise.init();
        }
        double d4 = d + 4096.0;
        int n = (int)d4 & 0xFF;
        int n2 = n + 1 & 0xFF;
        double d5 = d4 - (double)((int)d4);
        double d6 = d5 - 1.0;
        d4 = d2 + 4096.0;
        int n3 = (int)d4 & 0xFF;
        int n4 = n3 + 1 & 0xFF;
        double d7 = d4 - (double)((int)d4);
        double d8 = d7 - 1.0;
        d4 = d3 + 4096.0;
        int n5 = (int)d4 & 0xFF;
        int n6 = n5 + 1 & 0xFF;
        double d9 = d4 - (double)((int)d4);
        double d10 = d9 - 1.0;
        int n7 = p[n];
        int n8 = p[n2];
        int n9 = p[n7 + n3];
        int n10 = p[n8 + n3];
        int n11 = p[n7 + n4];
        int n12 = p[n8 + n4];
        d4 = Noise.sCurve(d5);
        double d11 = Noise.sCurve(d7);
        double d12 = Noise.sCurve(d9);
        double[] dArray = g3[n9 + n5];
        double d13 = d5 * dArray[0] + d7 * dArray[1] + d9 * dArray[2];
        dArray = g3[n10 + n5];
        double d14 = d6 * dArray[0] + d7 * dArray[1] + d9 * dArray[2];
        double d15 = ImageMath.lerp(d4, d13, d14);
        dArray = g3[n11 + n5];
        d13 = d5 * dArray[0] + d8 * dArray[1] + d10 * dArray[2];
        dArray = g3[n12 + n5];
        d14 = d6 * dArray[0] + d8 * dArray[1] + d10 * dArray[2];
        double d16 = ImageMath.lerp(d4, d13, d14);
        double d17 = ImageMath.lerp(d11, d15, d16);
        dArray = g3[n9 + n6];
        d13 = d5 * dArray[0] + d7 * dArray[1] + d9 * dArray[2];
        dArray = g3[n10 + n6];
        d14 = d6 * dArray[0] + d7 * dArray[1] + d9 * dArray[2];
        d15 = ImageMath.lerp(d4, d13, d14);
        dArray = g3[n11 + n6];
        d13 = d5 * dArray[0] + d8 * dArray[1] + d10 * dArray[2];
        dArray = g3[n12 + n6];
        d14 = d6 * dArray[0] + d8 * dArray[1] + d10 * dArray[2];
        d16 = ImageMath.lerp(d4, d13, d14);
        double d18 = ImageMath.lerp(d11, d15, d16);
        return 1.5 * ImageMath.lerp(d12, d17, d18);
    }

    private static void normalize2(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        dArray[0] = dArray[0] / d;
        dArray[1] = dArray[1] / d;
    }

    static void normalize3(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        dArray[0] = dArray[0] / d;
        dArray[1] = dArray[1] / d;
        dArray[2] = dArray[2] / d;
    }

    private static int random() {
        return randomGenerator.nextInt() & Integer.MAX_VALUE;
    }

    private static void init() {
        int n;
        int n2 = 0;
        while (n2 < 256) {
            Noise.p[n2] = n2;
            Noise.g1[n2] = (double)(Noise.random() % 512 - 256) / 256.0;
            n = 0;
            while (n < 2) {
                Noise.g2[n2][n] = (double)(Noise.random() % 512 - 256) / 256.0;
                ++n;
            }
            Noise.normalize2(g2[n2]);
            n = 0;
            while (n < 3) {
                Noise.g3[n2][n] = (double)(Noise.random() % 512 - 256) / 256.0;
                ++n;
            }
            Noise.normalize3(g3[n2]);
            ++n2;
        }
        n2 = 255;
        while (n2 >= 0) {
            int n3 = p[n2];
            n = Noise.random() % 256;
            Noise.p[n2] = p[n];
            Noise.p[n] = n3;
            --n2;
        }
        n2 = 0;
        while (n2 < 258) {
            Noise.p[256 + n2] = p[n2];
            Noise.g1[256 + n2] = g1[n2];
            n = 0;
            while (n < 2) {
                Noise.g2[256 + n2][n] = g2[n2][n];
                ++n;
            }
            n = 0;
            while (n < 3) {
                Noise.g3[256 + n2][n] = g3[n2][n];
                ++n;
            }
            ++n2;
        }
    }

    public static double[] findRange(Function1D function1D, double[] dArray) {
        if (dArray == null) {
            dArray = new double[2];
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = -100.0;
        while (d3 < 100.0) {
            double d4 = function1D.evaluate(d3);
            d = Math.min(d, d4);
            d2 = Math.max(d2, d4);
            d3 += 1.27139;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    public static double[] findRange(Function2D function2D, double[] dArray) {
        if (dArray == null) {
            dArray = new double[2];
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = -100.0;
        while (d3 < 100.0) {
            double d4 = -100.0;
            while (d4 < 100.0) {
                double d5 = function2D.evaluate(d4, d3);
                d = Math.min(d, d5);
                d2 = Math.max(d2, d5);
                d4 += 1.77139;
            }
            d3 += 1.35173;
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }
}

