/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.util.TimeUtils;

public enum Weekday {
    SU(0),
    MO(1),
    TU(2),
    WE(3),
    TH(4),
    FR(5),
    SA(6);

    public final int jsDayNum;
    public final int javaDayNum;
    private static Weekday[] VALUES;

    static {
        VALUES = new Weekday[7];
        System.arraycopy(Weekday.values(), 0, VALUES, 0, 7);
    }

    private Weekday(int wDayNum) {
        this.jsDayNum = wDayNum;
        this.javaDayNum = 1 + wDayNum;
    }

    public static Weekday firstDayOfWeekInMonth(int year, int month) {
        int result = TimeUtils.fixedFromGregorian(year, month, 1) % 7;
        return VALUES[result >= 0 ? result : result + 7];
    }

    public Weekday successor() {
        return VALUES[(this.ordinal() + 1) % 7];
    }

    public Weekday predecessor() {
        return VALUES[(this.ordinal() - 1 + 7) % 7];
    }

    public static Weekday valueOf(String string) {
        return Enum.valueOf(Weekday.class, string);
    }
}

